/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.rendering;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FlatMobRenderUtils {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final float VIEWPORT_FILL_RATIO = 0.92f;
    private static final float HALF = 0.5f;
    private static final Map<Mob, Mob> RENDER_CLONES = new WeakHashMap<Mob, Mob>();

    private FlatMobRenderUtils() {
    }

    public static boolean renderFlatMob(@NotNull GuiGraphics graphics, int left, int top, int size, @Nullable Mob mob, float opacity) {
        Mob renderMob = FlatMobRenderUtils.prepareRenderMob(mob);
        if (renderMob == null) {
            return false;
        }
        graphics.m_280588_(left, top, left + size, top + size);
        float centerX = (float)left + (float)size / 2.0f;
        float centerY = (float)top + (float)size / 2.0f;
        MobBounds bounds = FlatMobRenderUtils.captureBounds(renderMob);
        float scale = FlatMobRenderUtils.computeScale(bounds, size);
        Vector3f offset = new Vector3f(0.0f, bounds.height * 0.5f, 0.0f);
        Quaternionf baseRotation = Axis.f_252403_.m_252977_(180.0f);
        float originalBody = renderMob.f_20883_;
        float originalBodyO = renderMob.f_20884_;
        float originalYRot = renderMob.m_146908_();
        float originalYRotO = renderMob.f_19859_;
        float originalXRot = renderMob.m_146909_();
        float originalXRotO = renderMob.f_19860_;
        float originalHead = renderMob.f_20885_;
        float originalHeadO = renderMob.f_20886_;
        renderMob.m_5618_(180.0f);
        renderMob.f_20884_ = 180.0f;
        renderMob.m_146922_(180.0f);
        renderMob.f_19859_ = 180.0f;
        renderMob.m_146926_(0.0f);
        renderMob.f_19860_ = 0.0f;
        renderMob.m_5616_(180.0f);
        renderMob.f_20886_ = 180.0f;
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, opacity);
        graphics.m_280168_().m_85836_();
        FlatMobRenderUtils.renderEntity(graphics, centerX, centerY, scale, offset, baseRotation, renderMob);
        graphics.m_280168_().m_85849_();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Lighting.m_84931_();
        renderMob.m_5618_(originalBody);
        renderMob.f_20884_ = originalBodyO;
        renderMob.m_146922_(originalYRot);
        renderMob.f_19859_ = originalYRotO;
        renderMob.m_146926_(originalXRot);
        renderMob.f_19860_ = originalXRotO;
        renderMob.m_5616_(originalHead);
        renderMob.f_20886_ = originalHeadO;
        graphics.m_280618_();
        return true;
    }

    private static void renderEntity(@NotNull GuiGraphics graphics, float centerX, float centerY, float scale, @NotNull Vector3f offset, @NotNull Quaternionf modelRotation, @NotNull Mob mob) {
        graphics.m_280168_().m_85837_((double)centerX, (double)centerY, 50.0);
        graphics.m_280168_().m_85841_(scale, scale, -scale);
        graphics.m_280168_().m_252880_(offset.x, offset.y, offset.z);
        graphics.m_280168_().m_252781_(modelRotation);
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        LightTexture lightTexture = Minecraft.m_91087_().f_91063_.m_109154_();
        int previousLightTexture = RenderSystem.getShaderTexture((int)2);
        lightTexture.m_109896_();
        Vector3f frontLight = new Vector3f(0.0f, 0.0f, 1.0f).normalize();
        RenderSystem.setShaderLights((Vector3f)frontLight, (Vector3f)frontLight);
        dispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_((Entity)mob, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0));
        graphics.m_280262_();
        dispatcher.m_114468_(true);
        if (previousLightTexture == 0) {
            lightTexture.m_109891_();
        } else {
            RenderSystem.setShaderTexture((int)2, (int)previousLightTexture);
        }
        Lighting.m_84931_();
    }

    @NotNull
    private static MobBounds captureBounds(@NotNull Mob mob) {
        AABB boundingBox = mob.m_20191_();
        double width = boundingBox.f_82291_ - boundingBox.f_82288_;
        double height = boundingBox.f_82292_ - boundingBox.f_82289_;
        double depth = boundingBox.f_82293_ - boundingBox.f_82290_;
        float widthF = (float)Math.max(width, (double)0.001f);
        float heightF = (float)Math.max(height, (double)0.001f);
        float depthF = (float)Math.max(depth, (double)0.001f);
        return new MobBounds(heightF, Math.max(widthF, depthF));
    }

    private static float computeScale(@NotNull MobBounds bounds, int size) {
        float dominant = Math.max(bounds.height, bounds.horizontal);
        float available = Math.max((float)size * 0.92f, 1.0f);
        return available / dominant;
    }

    @Nullable
    private static Mob prepareRenderMob(@Nullable Mob source) {
        if (!FlatMobRenderUtils.isRenderableSource(source)) {
            FlatMobRenderUtils.evict(source);
            return null;
        }
        Level level = source.m_9236_();
        if (level == null) {
            FlatMobRenderUtils.evict(source);
            return null;
        }
        Mob clone = RENDER_CLONES.get(source);
        if (clone == null || clone.m_213877_() || clone.m_9236_() != level) {
            clone = FlatMobRenderUtils.createClone(source);
            if (clone == null) {
                FlatMobRenderUtils.evict(source);
                return null;
            }
            RENDER_CLONES.put(source, clone);
        }
        return clone;
    }

    private static boolean isRenderableSource(@Nullable Mob source) {
        return source != null && source.m_6084_() && !source.m_213877_();
    }

    private static void evict(@Nullable Mob source) {
        if (source != null) {
            RENDER_CLONES.remove(source);
        }
    }

    @Nullable
    private static Mob createClone(@NotNull Mob source) {
        Level level = source.m_9236_();
        if (level == null) {
            level = FlatMobRenderUtils.MC.f_91073_;
        }
        if (level == null) {
            return null;
        }
        Entity created = source.m_6095_().m_20615_(level);
        if (!(created instanceof Mob)) {
            return null;
        }
        Mob copy = (Mob)created;
        copy.m_20242_(true);
        copy.m_21557_(true);
        copy.f_19794_ = true;
        copy.m_20225_(true);
        FlatMobRenderUtils.copyMobData(source, copy);
        return copy;
    }

    private static void copyMobData(@NotNull Mob source, @NotNull Mob target) {
        CompoundTag tag = new CompoundTag();
        source.m_20240_(tag);
        tag.m_128379_("PersistenceRequired", false);
        target.m_20258_(tag);
        target.m_20242_(true);
        target.m_21557_(true);
        target.f_19794_ = true;
        target.m_20225_(true);
    }

    private static final class MobBounds {
        private final float height;
        private final float horizontal;

        private MobBounds(float height, float horizontal) {
            this.height = height;
            this.horizontal = horizontal;
        }
    }
}

