/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.util.death;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import de.keksuccino.spiffyhud.SpiffyHud;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeathPointStorage {
    private static final Logger LOGGER = LogManager.getLogger((String)"SpiffyHUD-DeathPointStorage");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path STORAGE_PATH = SpiffyHud.INSTANCE_DIR.toPath().resolve("death_point.json");
    private static final double CLEAR_DISTANCE_SQR = 25.0;
    @Nullable
    private static StoredDeathPoint cachedPoint;
    private static boolean loaded;

    private DeathPointStorage() {
    }

    public static synchronized void recordDeath(@NotNull Level level, double x, double y, double z) {
        StoredDeathPoint point;
        cachedPoint = point = new StoredDeathPoint(level.m_46472_().m_135782_().toString(), x, y, z);
        loaded = true;
        DeathPointStorage.write(point);
    }

    public static synchronized void clear() {
        DeathPointStorage.dropCachedAndDelete();
    }

    @Nullable
    public static synchronized StoredDeathPoint get() {
        if (!loaded) {
            cachedPoint = DeathPointStorage.read();
            loaded = true;
        }
        return cachedPoint;
    }

    public static synchronized void tick(@Nullable Player player) {
        if (player == null || player.m_21224_()) {
            return;
        }
        StoredDeathPoint point = DeathPointStorage.get();
        if (point == null) {
            return;
        }
        if (!point.dimensionMatches(player.m_9236_())) {
            return;
        }
        if (point.squaredDistanceTo(player.m_20185_(), player.m_20186_(), player.m_20189_()) <= 25.0) {
            DeathPointStorage.dropCachedAndDelete();
        }
    }

    private static void dropCachedAndDelete() {
        cachedPoint = null;
        loaded = true;
        try {
            Files.deleteIfExists(STORAGE_PATH);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to delete stored death point", (Throwable)ex);
        }
    }

    private static void write(@NotNull StoredDeathPoint point) {
        try {
            if (STORAGE_PATH.getParent() != null) {
                Files.createDirectories(STORAGE_PATH.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(STORAGE_PATH, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson((Object)point, (Appendable)writer);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to store death point", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static StoredDeathPoint read() {
        if (!Files.exists(STORAGE_PATH, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(STORAGE_PATH, StandardCharsets.UTF_8);){
            StoredDeathPoint data = (StoredDeathPoint)GSON.fromJson((Reader)reader, StoredDeathPoint.class);
            if (data == null) return null;
            if (!data.isValid()) return null;
            StoredDeathPoint storedDeathPoint = data;
            return storedDeathPoint;
        }
        catch (JsonParseException | IOException ex) {
            LOGGER.warn("Failed to read stored death point", ex);
        }
        return null;
    }

    public static final class StoredDeathPoint {
        private String dimension = "";
        private double x;
        private double y;
        private double z;

        public StoredDeathPoint() {
        }

        public StoredDeathPoint(@NotNull String dimension, double x, double y, double z) {
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isValid() {
            return this.dimension != null && !this.dimension.isBlank();
        }

        public boolean dimensionMatches(@NotNull Level level) {
            ResourceLocation key = this.dimensionKey();
            return key != null && key.equals((Object)level.m_46472_().m_135782_());
        }

        @Nullable
        public ResourceLocation dimensionKey() {
            return this.dimension == null ? null : ResourceLocation.m_135820_((String)this.dimension);
        }

        public double squaredDistanceTo(double px, double py, double pz) {
            double dx = this.x - px;
            double dy = this.y - py;
            double dz = this.z - pz;
            return dx * dx + dy * dy + dz * dz;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }
}

