/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.networking.Packet;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import de.keksuccino.spiffyhud.networking.packets.structure.playerpos.PlayerPosStructuresPacket;
import de.keksuccino.spiffyhud.networking.packets.structure.structures.StructuresPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsPlayerInStructureRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static long lastStructureUpdate = -1L;

    public IsPlayerInStructureRequirement() {
        super("spiffy_is_player_in_structure");
    }

    public boolean hasValue() {
        return true;
    }

    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            try {
                long now = System.currentTimeMillis();
                if (lastStructureUpdate + 1000L < now) {
                    PacketHandler.sendToServer((Packet)new PlayerPosStructuresPacket());
                    lastStructureUpdate = now;
                }
                return PlayerPosStructuresPacket.CACHED_CURRENT_STRUCTURES.contains(value);
            }
            catch (Exception ex) {
                LOGGER.error("[SPIFFY HUD] Failed to check for 'Is Player In Structure' requirement!", (Throwable)ex);
            }
        }
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"spiffyhud.requirements.is_player_in_structure", (Object[])new Object[0]);
    }

    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines((String)"spiffyhud.requirements.is_player_in_structure.desc", (String[])new String[0]));
    }

    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.requirements.categories.world", (Object[])new Object[0]);
    }

    public String getValueDisplayName() {
        return "";
    }

    public String getValuePreset() {
        return "minecraft:village";
    }

    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsPlayerInStructureValueConfigScreen s = new IsPlayerInStructureValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    public static class IsPlayerInStructureValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String oldStructureKey;
        protected CellScreen.TextInputCell structureKeyCell;
        protected EditBoxSuggestions structureKeySuggestions;

        protected IsPlayerInStructureValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.editor.elements.visibilityrequirements.edit_value"), callback);
            this.oldStructureKey = value;
        }

        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getStructureKeyString();
            this.addLabelCell((Component)Component.m_237115_((String)"spiffyhud.requirements.is_player_in_structure.key"));
            this.structureKeyCell = this.addTextInputCell(null, true, true).setText(id);
            this.addCellGroupEndSpacerCell();
            this.structureKeySuggestions = EditBoxSuggestions.createWithCustomSuggestions((Screen)this, (EditBox)this.structureKeyCell.editBox, (EditBoxSuggestions.SuggestionsRenderPosition)EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, new ArrayList<String>(StructuresPacket.CACHED_SERVER_STRUCTURE_KEYS));
            UIBase.applyDefaultWidgetSkinTo((Object)this.structureKeySuggestions);
            this.structureKeyCell.editBox.m_94151_(s -> this.structureKeySuggestions.m_93881_());
            this.addSpacerCell(20);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.m_88315_(graphics, mouseX, mouseY, partial);
            this.structureKeySuggestions.m_280540_(graphics, mouseX, mouseY);
        }

        public boolean m_7933_(int $$0, int $$1, int $$2) {
            if (this.structureKeySuggestions.m_93888_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_7933_($$0, $$1, $$2);
        }

        public boolean m_6050_(double $$0, double $$1, double $$2) {
            if (this.structureKeySuggestions.m_93882_($$2)) {
                return true;
            }
            return super.m_6050_($$0, $$1, $$2);
        }

        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (this.structureKeySuggestions.m_93884_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        @NotNull
        public String buildString() {
            return this.getStructureKeyString();
        }

        @NotNull
        protected String getStructureKeyString() {
            if (this.structureKeyCell != null) {
                return this.structureKeyCell.getText();
            }
            return this.oldStructureKey;
        }
    }
}

