/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.food;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import de.keksuccino.spiffyhud.util.rendering.SpiffyRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaLikePlayerFoodElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static final int BAR_WIDTH = 81;
    private static final int BAR_HEIGHT = 9;
    private final Minecraft minecraft = Minecraft.m_91087_();
    protected final RandomSource random = RandomSource.m_216327_();
    protected int tickCount;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikePlayerFoodElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.f_91074_ == null || this.minecraft.f_91073_ == null) {
            return;
        }
        int elementX = this.getAbsoluteX();
        int elementY = this.getAbsoluteY();
        Integer[] alignedPosition = SpiffyAlignment.calculateElementBodyPosition(this.spiffyAlignment, elementX, elementY, this.getAbsoluteWidth(), this.getAbsoluteHeight(), 81, 9);
        int barPosX = alignedPosition[0];
        int barPosY = alignedPosition[1];
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.renderFoodBar(graphics, barPosX, barPosY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    private void renderFoodBar(GuiGraphics graphics, int baseX, int baseY) {
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity);
        FoodData foodData = player.m_36324_();
        int foodLevel = foodData.m_38702_();
        if (VanillaLikePlayerFoodElement.isEditor()) {
            foodLevel = 9;
        }
        int numIcons = 10;
        int ICON_WIDTH = 9;
        int ICON_HEIGHT = 9;
        int ICON_SPACING = 8;
        boolean mirrorIcons = this.shouldRenderIconsLeftToRight();
        int hungerTextureOffset = 0;
        int textureBaseX = 16;
        if (player.m_21023_(MobEffects.f_19612_)) {
            textureBaseX += 36;
            hungerTextureOffset = 13;
        }
        int emptyIconTexX = 16 + hungerTextureOffset * 9;
        int fullIconTexX = textureBaseX + 36;
        int halfIconTexX = textureBaseX + 45;
        int texV = 27;
        int TEXTURE_WIDTH = 256;
        int TEXTURE_HEIGHT = 256;
        for (int i = 0; i < 10; ++i) {
            int iconX = mirrorIcons ? baseX + i * 8 : baseX + (9 - i) * 8;
            int iconY = baseY;
            if (foodData.m_38722_() <= 0.0f && this.tickCount % (foodLevel * 3 + 1) == 0) {
                iconY += this.random.m_188503_(3) - 1;
            }
            if (mirrorIcons) {
                SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, iconX, iconY, 0, emptyIconTexX, texV, 9, 9, 256, 256);
                if (i * 2 + 1 < foodLevel) {
                    SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, iconX, iconY, 0, fullIconTexX, texV, 9, 9, 256, 256);
                    continue;
                }
                if (i * 2 + 1 != foodLevel) continue;
                SpiffyRenderUtils.blitMirrored(graphics, GUI_ICONS_LOCATION, iconX, iconY, 0, halfIconTexX, texV, 9, 9, 256, 256);
                continue;
            }
            graphics.m_280218_(GUI_ICONS_LOCATION, iconX, iconY, emptyIconTexX, texV, 9, 9);
            if (i * 2 + 1 < foodLevel) {
                graphics.m_280218_(GUI_ICONS_LOCATION, iconX, iconY, fullIconTexX, texV, 9, 9);
                continue;
            }
            if (i * 2 + 1 != foodLevel) continue;
            graphics.m_280218_(GUI_ICONS_LOCATION, iconX, iconY, halfIconTexX, texV, 9, 9);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private boolean shouldRenderIconsLeftToRight() {
        return this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.TOP_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED;
    }

    @Nullable
    private Player getCameraPlayer() {
        Player p;
        Entity entity = Minecraft.m_91087_().m_91288_();
        return entity instanceof Player ? (p = (Player)entity) : null;
    }

    public int getAbsoluteWidth() {
        return 81;
    }

    public int getAbsoluteHeight() {
        return 9;
    }
}

