/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.vanillalike.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.spiffyhud.SpiffyUtils;
import de.keksuccino.spiffyhud.util.SizeAndPositionRecorder;
import de.keksuccino.spiffyhud.util.SpiffyAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VanillaLikeEffectsElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft minecraft = Minecraft.m_91087_();
    protected int tickCount;
    private int barHeight = 60;
    private int barWidth = 100;
    private boolean shouldRenderBar = false;
    @NotNull
    public SpiffyAlignment spiffyAlignment = SpiffyAlignment.TOP_LEFT;

    public VanillaLikeEffectsElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.tickCount = SpiffyUtils.getGuiAccessor().getTickCount_Spiffy();
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        if (this.minecraft.f_91073_ == null) {
            return;
        }
        this.shouldRenderBar = false;
        this.renderEffects(graphics, 0, 0);
        int elementAbsX = this.getAbsoluteX();
        int elementAbsY = this.getAbsoluteY();
        int elementHeight = this.getAbsoluteHeight();
        int baseY = elementAbsY;
        if (this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_CENTERED || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT) {
            baseY += (elementHeight - this.barHeight) / 2;
        } else if (this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_CENTERED || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT) {
            baseY += elementHeight - this.barHeight;
        }
        int baseX = elementAbsX;
        RenderSystem.enableBlend();
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
        this.shouldRenderBar = true;
        this.renderEffects(graphics, baseX, baseY);
        RenderingUtils.resetShaderColor((GuiGraphics)graphics);
    }

    protected void renderEffects(GuiGraphics graphics, int baseX, int baseY) {
        float iconTransparency;
        int iconY;
        int iconX;
        TextureAtlasSprite effectSprite;
        int fadeFactor;
        float iconAlpha;
        int finalIconX;
        int relativeX;
        MobEffectInstance effectInstance;
        int i;
        int requiredWidth;
        Screen currentScreen;
        List<MobEffectInstance> activeEffects = Objects.requireNonNull(this.minecraft.f_91074_).m_21220_();
        if (VanillaLikeEffectsElement.isEditor()) {
            activeEffects = List.of(new MobEffectInstance(MobEffects.f_19621_, 300), new MobEffectInstance(MobEffects.f_19607_, 300), new MobEffectInstance(MobEffects.f_19594_, 300));
        }
        if (activeEffects.isEmpty() || (currentScreen = this.minecraft.f_91080_) instanceof EffectRenderingInventoryScreen && ((EffectRenderingInventoryScreen)currentScreen).m_194018_()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity);
        ArrayList<MobEffectInstance> beneficialEffects = new ArrayList<MobEffectInstance>();
        ArrayList<MobEffectInstance> harmfulEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effectInstance2 : Ordering.natural().reverse().sortedCopy(activeEffects)) {
            if (!effectInstance2.m_19575_()) continue;
            if (effectInstance2.m_19544_().m_19486_()) {
                beneficialEffects.add(effectInstance2);
                continue;
            }
            harmfulEffects.add(effectInstance2);
        }
        ArrayList renderTasks = Lists.newArrayListWithExpectedSize((int)activeEffects.size());
        SizeAndPositionRecorder recorder = new SizeAndPositionRecorder();
        recorder.setWidthOffset(24);
        recorder.setHeightOffset(24);
        boolean isLeftAligned = this.spiffyAlignment == SpiffyAlignment.TOP_LEFT || this.spiffyAlignment == SpiffyAlignment.MID_LEFT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_LEFT;
        boolean isRightAligned = this.spiffyAlignment == SpiffyAlignment.TOP_RIGHT || this.spiffyAlignment == SpiffyAlignment.MID_RIGHT || this.spiffyAlignment == SpiffyAlignment.BOTTOM_RIGHT;
        int baseRowOffset = 1;
        if (this.minecraft.m_91402_()) {
            baseRowOffset += 15;
        }
        int beneficialRowY = baseY + baseRowOffset;
        int harmfulRowY = baseY + baseRowOffset + 26;
        int beneficialIconCount = beneficialEffects.size();
        int harmfulIconCount = harmfulEffects.size();
        int elementWidth = requiredWidth = Math.max(beneficialIconCount, harmfulIconCount) * 25;
        int beneficialStartX = isLeftAligned ? 0 : (isRightAligned ? elementWidth - beneficialIconCount * 25 : (elementWidth - beneficialIconCount * 25) / 2);
        int harmfulStartX = isLeftAligned ? 0 : (isRightAligned ? elementWidth - harmfulIconCount * 25 : (elementWidth - harmfulIconCount * 25) / 2);
        MobEffectTextureManager effectTextureManager = this.minecraft.m_91306_();
        for (i = 0; i < beneficialIconCount; ++i) {
            effectInstance = (MobEffectInstance)beneficialEffects.get(i);
            relativeX = beneficialStartX + 25 * i;
            finalIconX = baseX + relativeX;
            iconAlpha = 1.0f;
            if (this.shouldRenderBar) {
                if (effectInstance.m_19571_()) {
                    graphics.m_280218_(AbstractContainerScreen.f_97725_, finalIconX, beneficialRowY, 165, 166, 24, 24);
                } else {
                    graphics.m_280218_(AbstractContainerScreen.f_97725_, finalIconX, beneficialRowY, 141, 166, 24, 24);
                    if (effectInstance.m_267633_(200)) {
                        int duration = effectInstance.m_19557_();
                        fadeFactor = 10 - duration / 20;
                        iconAlpha = Mth.m_14036_((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)fadeFactor / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
            }
            effectSprite = effectTextureManager.m_118732_(effectInstance.m_19544_());
            recorder.updateX(finalIconX);
            recorder.updateY(beneficialRowY);
            iconX = finalIconX;
            iconY = beneficialRowY;
            float f = iconTransparency = iconAlpha > this.opacity ? this.opacity : iconAlpha;
            if (!this.shouldRenderBar) continue;
            renderTasks.add(() -> {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, iconTransparency);
                graphics.m_280159_(iconX + 3, iconY + 3, 0, 18, 18, effectSprite);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
        for (i = 0; i < harmfulIconCount; ++i) {
            effectInstance = (MobEffectInstance)harmfulEffects.get(i);
            relativeX = harmfulStartX + 25 * i;
            finalIconX = baseX + relativeX;
            iconAlpha = 1.0f;
            if (this.shouldRenderBar) {
                if (effectInstance.m_19571_()) {
                    graphics.m_280218_(AbstractContainerScreen.f_97725_, finalIconX, harmfulRowY, 165, 166, 24, 24);
                } else {
                    graphics.m_280218_(AbstractContainerScreen.f_97725_, finalIconX, harmfulRowY, 141, 166, 24, 24);
                    if (effectInstance.m_267633_(200)) {
                        int duration = effectInstance.m_19557_();
                        fadeFactor = 10 - duration / 20;
                        iconAlpha = Mth.m_14036_((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)fadeFactor / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
            }
            effectSprite = effectTextureManager.m_118732_(effectInstance.m_19544_());
            recorder.updateX(finalIconX);
            recorder.updateY(harmfulRowY);
            iconX = finalIconX;
            iconY = harmfulRowY;
            float f = iconTransparency = iconAlpha > this.opacity ? this.opacity : iconAlpha;
            if (!this.shouldRenderBar) continue;
            renderTasks.add(() -> {
                graphics.m_280246_(1.0f, 1.0f, 1.0f, iconTransparency);
                graphics.m_280159_(iconX + 3, iconY + 3, 0, 18, 18, effectSprite);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            });
        }
        this.barHeight = recorder.getHeight();
        this.barWidth = requiredWidth;
        renderTasks.forEach(Runnable::run);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getAbsoluteWidth() {
        return this.barWidth;
    }

    public int getAbsoluteHeight() {
        return this.barHeight;
    }
}

