/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.singlelinetext;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.util.ComponentUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleLineTextElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_TEXT_SCALE_STRING = "1.0";
    private static final float DEFAULT_TEXT_SCALE = 1.0f;
    private static final float MIN_TEXT_SCALE = 0.3f;
    @Nullable
    public String text = null;
    @NotNull
    public String textScale = "1.0";

    public SingleLineTextElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        float scale = this.resolveTextScale();
        if (this.shouldRender()) {
            MutableComponent c;
            Object object = c = this.text != null ? ComponentUtils.fromJsonOrPlainText(this.text) : Component.m_237113_((String)"--------------------");
            if (c.getString().isBlank() && SingleLineTextElement.isEditor()) {
                c = Component.m_237113_((String)"--------------------");
            }
            this.baseWidth = (int)Math.ceil((float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)c) * scale);
            if (this.baseWidth < 10 && SingleLineTextElement.isEditor()) {
                this.baseWidth = 10;
            }
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)this.getAbsoluteX(), (float)this.getAbsoluteY(), 0.0f);
            pose.m_85841_(scale, scale, 1.0f);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)c, 0, 0, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            pose.m_85849_();
        } else {
            this.baseWidth = 100;
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.baseHeight = Math.max(1, (int)Math.ceil(9.0f * scale));
    }

    private float resolveTextScale() {
        String raw = this.textScale;
        if (raw == null || raw.isBlank()) {
            return 1.0f;
        }
        String replaced = PlaceholderParser.replacePlaceholders((String)raw);
        if (!replaced.isBlank() && MathUtils.isFloat((String)replaced)) {
            try {
                float parsed = Float.parseFloat(replaced);
                if (Float.isNaN(parsed) || Float.isInfinite(parsed)) {
                    return 1.0f;
                }
                return Math.max(0.3f, parsed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1.0f;
    }
}

