/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.eraser;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.spiffyhud.customization.SpiffyOverlayScreen;
import de.keksuccino.spiffyhud.customization.elements.eraser.EraserEditorElement;
import de.keksuccino.spiffyhud.customization.elements.eraser.EraserElement;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EraserElementBuilder
extends ElementBuilder<EraserElement, EraserEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EraserElementBuilder() {
        super("spiffy_eraser");
    }

    @NotNull
    public EraserElement buildDefaultInstance() {
        EraserElement i = new EraserElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        i.inEditorColor = DrawableColor.of((Color)new Color(157, 19, 93, 179));
        i.stayOnScreen = false;
        return i;
    }

    @Nullable
    public EraserElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        EraserElement e = (EraserElement)super.deserializeElementInternal(serialized);
        if (e != null) {
            e.stayOnScreen = this.deserializeBoolean(e.stayOnScreen, serialized.getValue("stay_on_screen"));
        }
        return e;
    }

    public EraserElement deserializeElement(@NotNull SerializedElement serialized) {
        EraserElement element = this.buildDefaultInstance();
        String aggressionLevel = serialized.getValue("aggression_level");
        if (aggressionLevel != null) {
            element.aggressionLevel = Objects.requireNonNullElse(EraserElement.AggressionLevel.getByName(aggressionLevel), EraserElement.AggressionLevel.NORMAL);
        }
        return element;
    }

    protected SerializedElement serializeElement(@NotNull EraserElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("aggression_level", element.aggressionLevel.getName());
        return serializeTo;
    }

    @NotNull
    public EraserEditorElement wrapIntoEditorElement(@NotNull EraserElement element, @NotNull LayoutEditorScreen editor) {
        return new EraserEditorElement(element, editor);
    }

    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.m_237115_((String)"spiffyhud.elements.hud_eraser");
    }

    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines((String)"spiffyhud.elements.hud_eraser.desc", (String[])new String[0]);
    }

    public boolean shouldShowUpInEditorElementMenu(@NotNull LayoutEditorScreen editor) {
        return editor.layoutTargetScreen instanceof SpiffyOverlayScreen;
    }
}

