/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.spiffyhud.customization.elements.eraser;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EraserElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public AggressionLevel aggressionLevel = AggressionLevel.NORMAL;

    public EraserElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    public boolean supportsRotation() {
        return false;
    }

    public boolean supportsTilting() {
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (EraserElement.isEditor()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            graphics.m_280509_(x, y, x + w, y + h, this.inEditorColor.getColorInt());
            graphics.m_280588_(x, y, x + w, y + h);
            Font font = Minecraft.m_91087_().f_91062_;
            Component component = this.getDisplayName();
            int n = x + w / 2;
            int n2 = y + h / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            graphics.m_280653_(font, component, n, n2 - 9 / 2, -1);
            graphics.m_280618_();
        }
    }

    public static enum AggressionLevel implements LocalizedCycleEnum<AggressionLevel>
    {
        NORMAL("normal"),
        AGGRESSIVE("aggressive");

        private final String name;

        private AggressionLevel(String name) {
            this.name = name;
        }

        @NotNull
        public String getLocalizationKeyBase() {
            return "spiffyhud.aggression_level";
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Style getValueComponentStyle() {
            return (Style)WARNING_TEXT_STYLE.get();
        }

        @NotNull
        public AggressionLevel[] getValues() {
            return AggressionLevel.values();
        }

        @Nullable
        public AggressionLevel getByNameInternal(@NotNull String name) {
            return AggressionLevel.getByName(name);
        }

        @Nullable
        public static AggressionLevel getByName(@NotNull String name) {
            for (AggressionLevel a : AggressionLevel.values()) {
                if (!a.name.equals(name)) continue;
                return a;
            }
            return null;
        }
    }
}

