/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.mixin.block_entity;

import com.cerbon.better_beacons.BetterBeacons;
import com.cerbon.better_beacons.advancement.BBCriteriaTriggers;
import com.cerbon.better_beacons.datapack.BaseBlocksAmplifierManager;
import com.cerbon.better_beacons.datapack.PaymentItemsRangeManager;
import com.cerbon.better_beacons.menu.custom.NewBeaconMenu;
import com.cerbon.better_beacons.util.BBConstants;
import com.cerbon.better_beacons.util.BBUtils;
import com.cerbon.better_beacons.util.StringToIntMap;
import com.cerbon.better_beacons.util.mixin.BeaconRedirectionAndTransparency;
import com.cerbon.better_beacons.util.mixin.IBeaconBlockEntityMixin;
import com.cerbon.cerbons_api.api.static_utilities.MiscUtils;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeaconBlockEntity.class})
public abstract class BeaconBlockEntityMixin
extends BlockEntity
implements IBeaconBlockEntityMixin {
    @Shadow
    @Final
    public static final MobEffect[][] f_58646_ = BBUtils.getBeaconEffectsFromConfigFile();
    @Shadow
    @Final
    private static final Set<MobEffect> f_58647_ = Arrays.stream(f_58646_).flatMap(Arrays::stream).collect(Collectors.toSet());
    @Shadow
    List<BeaconBlockEntity.BeaconBeamSection> f_58648_;
    @Shadow
    MobEffect f_58652_;
    @Shadow
    MobEffect f_58653_;
    @Unique
    private MobEffect bb_tertiaryEffect;
    @Unique
    private String bb_paymentItem;
    @Unique
    private int bb_primaryEffectAmplifier;
    @Shadow
    private LockCode f_58655_;
    @Shadow
    int f_58650_;
    @Shadow
    @Final
    private ContainerData f_58656_ = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BeaconBlockEntityMixin.this.f_58650_;
                case 1 -> MobEffect.m_216882_((MobEffect)BeaconBlockEntityMixin.this.f_58652_);
                case 2 -> MobEffect.m_216882_((MobEffect)BeaconBlockEntityMixin.this.f_58653_);
                case 3 -> MobEffect.m_216882_((MobEffect)BeaconBlockEntityMixin.this.bb_tertiaryEffect);
                case 4 -> StringToIntMap.getInt(BeaconBlockEntityMixin.this.bb_paymentItem);
                case 5 -> BeaconBlockEntityMixin.this.bb_primaryEffectAmplifier;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BeaconBlockEntityMixin.this.f_58650_ = value;
                    break;
                }
                case 1: {
                    if (!((BeaconBlockEntityMixin)BeaconBlockEntityMixin.this).f_58857_.f_46443_ && !BeaconBlockEntityMixin.this.f_58648_.isEmpty()) {
                        BeaconBlockEntity.m_155103_((Level)BeaconBlockEntityMixin.this.f_58857_, (BlockPos)BeaconBlockEntityMixin.this.f_58858_, (SoundEvent)SoundEvents.f_11739_);
                    }
                    BeaconBlockEntityMixin.this.f_58652_ = BeaconBlockEntityMixin.m_58686_(value);
                    break;
                }
                case 2: {
                    BeaconBlockEntityMixin.this.f_58653_ = BeaconBlockEntityMixin.m_58686_(value);
                    break;
                }
                case 3: {
                    BeaconBlockEntityMixin.this.bb_tertiaryEffect = BeaconBlockEntityMixin.m_58686_(value);
                    break;
                }
                case 4: {
                    BeaconBlockEntityMixin.this.bb_paymentItem = StringToIntMap.getString(value);
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    @Shadow
    public abstract Component m_5446_();

    @Shadow
    static MobEffect m_58686_(int effectId) {
        return null;
    }

    public BeaconBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void bb_addCustomData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("BBTertiary", MobEffect.m_216882_((MobEffect)this.bb_tertiaryEffect));
        tag.m_128405_("BBPrimaryEffectAmplifier", this.bb_primaryEffectAmplifier);
        if (this.bb_paymentItem != null) {
            tag.m_128359_("BBPaymentItem", this.bb_paymentItem);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void bb_readCustomData(@NotNull CompoundTag tag, CallbackInfo ci) {
        this.bb_tertiaryEffect = BeaconBlockEntityMixin.m_58686_(tag.m_128451_("BBTertiary"));
        this.bb_primaryEffectAmplifier = tag.m_128451_("BBPrimaryEffectAmplifier");
        if (tag.m_128441_("BBPaymentItem")) {
            this.bb_paymentItem = tag.m_128461_("BBPaymentItem");
            StringToIntMap.addString(this.bb_paymentItem);
        }
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="CONSTANT", args={"intValue=0"}, ordinal=0)})
    private static int bb_tick(int val, Level level, BlockPos pos, BlockState state, BeaconBlockEntity beaconBlockEntity) {
        return BeaconRedirectionAndTransparency.tickBeacon(beaconBlockEntity);
    }

    @ModifyVariable(method={"applyEffects"}, at=@At(value="LOAD", ordinal=0))
    private static double bb_increaseRangeBasedOnPaymentItem(double defaultRange, @NotNull Level level, BlockPos pos, int levels, @Nullable MobEffect primary, @Nullable MobEffect secondary) {
        BeaconBlockEntity beaconBlockEntity;
        String paymentItem;
        BlockEntity blockEntity;
        if (BetterBeacons.config.beaconRangeAndAmplifier.isPaymentItemRangeEnabled && (blockEntity = level.m_7702_(pos)) instanceof BeaconBlockEntity && (paymentItem = ((IBeaconBlockEntityMixin)(beaconBlockEntity = (BeaconBlockEntity)blockEntity)).bb_getPaymentItem()) != null) {
            return (double)PaymentItemsRangeManager.getItemRangeMap().getOrDefault(paymentItem, 0).intValue() + defaultRange;
        }
        return defaultRange;
    }

    @ModifyConstant(method={"applyEffects"}, constant={@Constant(intValue=0, ordinal=0)})
    private static int bb_setPrimaryEffectAmplifier(int amplifier, Level level, BlockPos pos, int levels, MobEffect primary, MobEffect secondary) {
        BlockEntity blockEntity;
        if (BetterBeacons.config.beaconRangeAndAmplifier.isBaseBlockAmplifierEnabled && (blockEntity = level.m_7702_(pos)) instanceof BeaconBlockEntity) {
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            return ((IBeaconBlockEntityMixin)beaconBlockEntity).bb_getPrimaryEffectAmplifier();
        }
        return amplifier;
    }

    @ModifyConstant(method={"applyEffects"}, constant={@Constant(intValue=1, ordinal=0)})
    private static int bb_setUpgradeAmplifier(int amplifier, Level level, BlockPos pos, int levels, MobEffect primary, MobEffect secondary) {
        BlockEntity blockEntity;
        if (BetterBeacons.config.beaconRangeAndAmplifier.isBaseBlockAmplifierEnabled && (blockEntity = level.m_7702_(pos)) instanceof BeaconBlockEntity) {
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            return ((IBeaconBlockEntityMixin)beaconBlockEntity).bb_getPrimaryEffectAmplifier() + 1;
        }
        return amplifier;
    }

    @Inject(method={"applyEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;", shift=At.Shift.BY, by=2)})
    private static void bb_applyTertiaryEffects(Level level, BlockPos pos, int levels, MobEffect primary, MobEffect secondary, CallbackInfo ci, @Local(ordinal=2) int j, @Local(ordinal=0) List<Player> players, @Local(ordinal=0) AABB aabb) {
        BlockEntity blockEntity;
        if (BetterBeacons.config.beaconEffects.isTertiaryEffectsEnabled && (blockEntity = level.m_7702_(pos)) instanceof BeaconBlockEntity) {
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            MobEffect tertiary = ((IBeaconBlockEntityMixin)beaconBlockEntity).bb_getTertiaryEffect();
            if (levels >= 5 && primary != tertiary && secondary != tertiary && tertiary != null) {
                for (Player player : players) {
                    player.m_7292_(new MobEffectInstance(tertiary, j, 0, true, true));
                }
                if (MiscUtils.isModLoaded((String)"beaconsforall")) {
                    try {
                        Class<?> bfaClass = Class.forName("com.illusivesoulworks.beaconsforall.BeaconsForAllMod");
                        Method canApplyEffectsMethod = bfaClass.getMethod("canApplyEffects", LivingEntity.class);
                        List livingEntities = level.m_6443_(LivingEntity.class, aabb, livingEntity -> {
                            try {
                                return (Boolean)canApplyEffectsMethod.invoke(null, livingEntity);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                BBConstants.LOGGER.error("Cannot invoke method 'canApplyEffects' from BeaconsForAllMod", (Throwable)e);
                                return false;
                            }
                        });
                        for (LivingEntity livingEntity2 : livingEntities) {
                            livingEntity2.m_7292_(new MobEffectInstance(tertiary, j, 0, true, true));
                        }
                    }
                    catch (ClassNotFoundException | NoSuchMethodException e) {
                        BBConstants.LOGGER.error("Class/Method from BeaconsForAllMod mod does not exist", (Throwable)e);
                    }
                }
            }
        }
    }

    @Inject(method={"updateBase"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bb_makeBeaconBaseGoesTillLevelFiveAndChangeAmplifierBasedOnTheBeaconBaseBlock(Level level, int beaconX, int beaconY, int beaconZ, CallbackInfoReturnable<Integer> cir) {
        BlockEntity blockEntity = level.m_7702_(new BlockPos(beaconX, beaconY, beaconZ));
        int pyramidMaxLevel = BetterBeacons.config.beaconEffects.isTertiaryEffectsEnabled ? 5 : 4;
        int pyramidLevel = 0;
        if (blockEntity instanceof BeaconBlockEntity) {
            int y;
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            IBeaconBlockEntityMixin beaconMixin = (IBeaconBlockEntityMixin)beaconBlockEntity;
            BlockState firstBlockState = null;
            boolean canIncreaseAmplifier = true;
            int paymentItemRange = PaymentItemsRangeManager.getItemRangeMap().getOrDefault(beaconMixin.bb_getPaymentItem(), 0);
            HashMap<Block, Integer> blockAmplifierMap = BaseBlocksAmplifierManager.getBlockAmplifierMap();
            int i = 1;
            while (i <= pyramidMaxLevel && (y = beaconY - i) >= level.m_141937_()) {
                boolean flag = true;
                block1: for (int x = beaconX - i; x <= beaconX + i && flag; ++x) {
                    for (int z = beaconZ - i; z <= beaconZ + i; ++z) {
                        BlockState currentBlockState = level.m_8055_(new BlockPos(x, y, z));
                        if (!currentBlockState.m_204336_(BlockTags.f_13079_)) {
                            flag = false;
                            continue block1;
                        }
                        if (firstBlockState == null) {
                            firstBlockState = currentBlockState;
                            continue;
                        }
                        if (currentBlockState.m_60713_(firstBlockState.m_60734_()) && canIncreaseAmplifier && BetterBeacons.config.beaconRangeAndAmplifier.isBaseBlockAmplifierEnabled) {
                            beaconMixin.bb_setPrimaryEffectAmplifier(blockAmplifierMap.getOrDefault(currentBlockState.m_60734_(), 0));
                            continue;
                        }
                        beaconMixin.bb_setPrimaryEffectAmplifier(0);
                        canIncreaseAmplifier = false;
                    }
                }
                if (!flag) break;
                pyramidLevel = i++;
            }
            if (!level.m_5776_() && canIncreaseAmplifier && beaconMixin.bb_getPrimaryEffectAmplifier() > BaseBlocksAmplifierManager.getLowestAmplifier()) {
                for (ServerPlayer serverplayer : BBUtils.getPlayersNearBeacon(beaconBlockEntity.m_58904_(), beaconX, beaconY, beaconZ)) {
                    BBCriteriaTriggers.INCREASE_EFFECTS_STRENGTH.trigger(serverplayer);
                }
            }
            if (!level.m_5776_() && canIncreaseAmplifier && pyramidLevel == pyramidMaxLevel && beaconMixin.bb_getPrimaryEffectAmplifier() == BaseBlocksAmplifierManager.getHighestAmplifier() && paymentItemRange == PaymentItemsRangeManager.getHighestRange()) {
                for (ServerPlayer serverplayer : BBUtils.getPlayersNearBeacon(beaconBlockEntity.m_58904_(), beaconX, beaconY, beaconZ)) {
                    BBCriteriaTriggers.TRUE_FULL_POWER.trigger(serverplayer);
                }
            }
        }
        cir.setReturnValue((Object)pyramidLevel);
    }

    @Inject(method={"createMenu"}, at={@At(value="RETURN")}, cancellable=true)
    private void better_beacons_addNewBeaconMenu(int containerId, Inventory playerInventory, Player player, @NotNull CallbackInfoReturnable<AbstractContainerMenu> cir) {
        cir.setReturnValue((Object)(BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.f_58655_, (Component)this.m_5446_()) ? new NewBeaconMenu(containerId, (Container)playerInventory, this.f_58656_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_())) : null));
    }

    @Override
    public String bb_getPaymentItem() {
        return this.bb_paymentItem;
    }

    @Override
    public MobEffect bb_getTertiaryEffect() {
        return this.bb_tertiaryEffect;
    }

    @Override
    public int bb_getPrimaryEffectAmplifier() {
        return this.bb_primaryEffectAmplifier;
    }

    @Override
    public void bb_setPrimaryEffectAmplifier(int amplifier) {
        this.bb_primaryEffectAmplifier = amplifier;
    }
}

