/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.client.screen;

import com.cerbon.better_beacons.BetterBeacons;
import com.cerbon.better_beacons.config.custom.BeaconPaymentItemsUI;
import com.cerbon.better_beacons.menu.custom.NewBeaconMenu;
import com.cerbon.better_beacons.packet.custom.BeaconC2SPacket;
import com.cerbon.better_beacons.util.BBUtils;
import com.cerbon.cerbons_api.api.network.Dispatcher;
import com.cerbon.cerbons_api.api.static_utilities.RegistryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewBeaconScreen
extends AbstractContainerScreen<NewBeaconMenu> {
    private static final ResourceLocation BEACON_TEXTURE_LOCATION = new ResourceLocation(NewBeaconMenu.isTertiaryEffectsEnabled ? "textures/gui/container/beacon2.png" : "textures/gui/container/beacon1.png");
    private static final Component PRIMARY_EFFECT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.primary");
    private static final Component SECONDARY_EFFECT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.secondary");
    private static final Component TERTIARY_EFFECT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.better_beacons.tertiary_power.label");
    private static final Component BEACON_RANGE_LABEL = Component.m_237115_((String)"block.minecraft.beacon.better_beacons.beacon_range.label");
    private static final Component CURRENT_PAYMENT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.better_beacons.current_payment.label");
    private static final Component PAYMENT_ITEM_LABEL = Component.m_237115_((String)"block.minecraft.beacon.better_beacons.payment_item.label");
    private static final Component PLUS_LABEL = Component.m_237115_((String)"block.minecraft.beacon.better_beacons.plus.label");
    private static final Component MINUS_LABEL = Component.m_237115_((String)"block.minecraft.beacon.better_beacons.minus.label");
    private static final Tooltip CONFIRM_BUTTON_TOOLTIP = Tooltip.m_257550_((Component)Component.m_237115_((String)"block.minecraft.beacon.better_beacons.confirm_button.tooltip"));
    private static final Tooltip CANCEL_BUTTON_REMOVE_EFFECTS_TOOLTIP = Tooltip.m_257550_((Component)Component.m_237115_((String)"block.minecraft.beacon.better_beacons.cancel_button_remove_effects.tooltip"));
    private static final Tooltip CANCEL_BUTTON_CLOSE_CONTAINER_TOOLTIP = Tooltip.m_257550_((Component)Component.m_237115_((String)"block.minecraft.beacon.better_beacons.cancel_button_close_container.tooltip"));
    @Nullable
    MobEffect primary;
    @Nullable
    MobEffect secondary;
    @Nullable
    MobEffect tertiary;
    int primaryEffectAmplifier;
    boolean isEffectsActive;
    String paymentItem;
    private final List<BeaconButton> beaconButtons = new ArrayList<BeaconButton>();

    public NewBeaconScreen(final NewBeaconMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = NewBeaconMenu.isTertiaryEffectsEnabled ? 256 : 230;
        this.f_97727_ = 219;
        menu.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu containerToSend, int dataSlotIndex, @NotNull ItemStack itemStack) {
            }

            public void m_142153_(@NotNull AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
                NewBeaconScreen.this.primary = menu.getPrimaryEffect();
                NewBeaconScreen.this.secondary = menu.getSecondaryEffect();
                NewBeaconScreen.this.tertiary = menu.getTertiaryEffect();
                NewBeaconScreen.this.isEffectsActive = menu.isEffectsActive();
                NewBeaconScreen.this.paymentItem = menu.getPaymentItem();
                NewBeaconScreen.this.primaryEffectAmplifier = menu.getPrimaryEffectAmplifier();
            }
        });
    }

    private <T extends AbstractWidget> void addBeaconButton(T beaconButton) {
        this.m_142416_((GuiEventListener)beaconButton);
        this.beaconButtons.add((BeaconButton)beaconButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.beaconButtons.clear();
        this.addBeaconButton(new BeaconConfirmButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 171 : this.f_97735_ + 172, this.f_97736_ + 106));
        this.addBeaconButton(new BeaconCancelButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 196 : this.f_97735_ + 197, this.f_97736_ + 106));
        for (int i = 0; i <= 2; ++i) {
            int j = BeaconBlockEntity.f_58646_[i].length;
            int k = j * 22 + (j - 1) * 2;
            for (int l = 0; l < j; ++l) {
                MobEffect mobeffect = BeaconBlockEntity.f_58646_[i][l];
                BeaconPowerButton beaconscreen$beaconpowerbutton = new BeaconPowerButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 74 + l * 24 - k / 2 : this.f_97735_ + 76 + l * 24 - k / 2, this.f_97736_ + 22 + i * 25, mobeffect, true, false, i);
                beaconscreen$beaconpowerbutton.f_93623_ = false;
                this.addBeaconButton(beaconscreen$beaconpowerbutton);
            }
        }
        int j1 = BeaconBlockEntity.f_58646_[3].length;
        int k1 = j1 * 22 + (j1 - 1) * 2;
        for (int l1 = 0; l1 < j1; ++l1) {
            MobEffect mobeffect1 = BeaconBlockEntity.f_58646_[3][l1];
            BeaconPowerButton beaconscreen$beaconpowerbutton2 = new BeaconPowerButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 164 + l1 * 24 - k1 / 2 : this.f_97735_ + 168 + l1 * 24 - k1 / 2, this.f_97736_ + 47, mobeffect1, false, true, 3);
            beaconscreen$beaconpowerbutton2.f_93623_ = false;
            this.addBeaconButton(beaconscreen$beaconpowerbutton2);
        }
        if (NewBeaconMenu.isTertiaryEffectsEnabled) {
            int j2 = BeaconBlockEntity.f_58646_[4].length;
            for (int i = 0; i < j2; ++i) {
                MobEffect mobEffect2 = BeaconBlockEntity.f_58646_[4][i];
                BeaconPowerButton beaconscreen$beaconpowerbutton3 = new BeaconPowerButton(this.f_97735_ + 222, this.f_97736_ + 47 + i * 25, mobEffect2, false, false, 4);
                beaconscreen$beaconpowerbutton3.f_93623_ = false;
                this.addBeaconButton(beaconscreen$beaconpowerbutton3);
            }
        }
        BeaconUpgradePowerButton beaconscreen$beaconpowerbutton1 = new BeaconUpgradePowerButton(NewBeaconMenu.isTertiaryEffectsEnabled ? this.f_97735_ + 153 : this.f_97735_ + 156, this.f_97736_ + 72, BeaconBlockEntity.f_58646_[0][0]);
        beaconscreen$beaconpowerbutton1.f_93624_ = false;
        this.addBeaconButton(beaconscreen$beaconpowerbutton1);
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtons();
    }

    void updateButtons() {
        int i = ((NewBeaconMenu)this.f_97732_).getLevels();
        this.beaconButtons.forEach(button -> button.updateStatus(i));
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280653_(this.f_96547_, PRIMARY_EFFECT_LABEL, NewBeaconMenu.isTertiaryEffectsEnabled ? 60 : 63, 10, 0xE0E0E0);
        guiGraphics.m_280653_(this.f_96547_, SECONDARY_EFFECT_LABEL, NewBeaconMenu.isTertiaryEffectsEnabled ? 165 : 170, 10, 0xE0E0E0);
        if (BetterBeacons.config.beaconRangeAndAmplifier.isPaymentItemRangeEnabled) {
            guiGraphics.m_280653_(this.f_96547_, BEACON_RANGE_LABEL, NewBeaconMenu.isTertiaryEffectsEnabled ? 74 : 77, 105, 0xE0E0E0);
            guiGraphics.m_280653_(this.f_96547_, PLUS_LABEL, NewBeaconMenu.isTertiaryEffectsEnabled ? 20 : 23, 106, 0xE0E0E0);
            guiGraphics.m_280653_(this.f_96547_, MINUS_LABEL, NewBeaconMenu.isTertiaryEffectsEnabled ? 128 : 131, 106, 0xE0E0E0);
        } else {
            guiGraphics.m_280653_(this.f_96547_, PAYMENT_ITEM_LABEL, NewBeaconMenu.isTertiaryEffectsEnabled ? 74 : 77, 105, 0xE0E0E0);
        }
        if (NewBeaconMenu.isTertiaryEffectsEnabled) {
            guiGraphics.m_280653_(this.f_96547_, TERTIARY_EFFECT_LABEL, 233, 10, 0xE0E0E0);
            guiGraphics.m_280653_(this.f_96547_, CURRENT_PAYMENT_LABEL, 239, 106, 0xE0E0E0);
        }
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        BeaconPaymentItemsUI paymentItemsUI = BetterBeacons.config.beaconPaymentItemsUI;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(BEACON_TEXTURE_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)paymentItemsUI.first.item)), NewBeaconMenu.isTertiaryEffectsEnabled ? i + paymentItemsUI.first.tertiaryPosX : i + paymentItemsUI.first.posX, j + 114);
        guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)paymentItemsUI.second.item)), NewBeaconMenu.isTertiaryEffectsEnabled ? i + paymentItemsUI.second.tertiaryPosX : i + paymentItemsUI.second.posX, j + 114);
        guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)paymentItemsUI.third.item)), NewBeaconMenu.isTertiaryEffectsEnabled ? i + paymentItemsUI.third.tertiaryPosX : i + paymentItemsUI.third.posX, j + 114);
        guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)paymentItemsUI.fourth.item)), NewBeaconMenu.isTertiaryEffectsEnabled ? i + paymentItemsUI.fourth.tertiaryPosX : i + paymentItemsUI.fourth.posX, j + 114);
        guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)paymentItemsUI.fifth.item)), NewBeaconMenu.isTertiaryEffectsEnabled ? i + paymentItemsUI.fifth.tertiaryPosX : i + paymentItemsUI.fifth.posX, j + 114);
        guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)paymentItemsUI.sixth.item)), NewBeaconMenu.isTertiaryEffectsEnabled ? i + paymentItemsUI.sixth.tertiaryPosX : i + paymentItemsUI.sixth.posX, j + 114);
        if (this.paymentItem != null && NewBeaconMenu.isTertiaryEffectsEnabled) {
            guiGraphics.m_280480_(new ItemStack((ItemLike)RegistryUtils.getItemByKey((String)this.paymentItem)), i + 165 + 66, j + 114);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public static interface BeaconButton {
        public void updateStatus(int var1);
    }

    public class BeaconConfirmButton
    extends BeaconSpriteScreenButton {
        protected BeaconConfirmButton(int x, int y) {
            super(x, y, 90, 220, CommonComponents.f_130655_);
            if (BetterBeacons.config.beaconButtons.isConfirmButtonTooltipEnabled) {
                this.m_257544_(CONFIRM_BUTTON_TOOLTIP);
            }
        }

        public void m_5691_() {
            Dispatcher.sendToServer((Object)new BeaconC2SPacket(Optional.ofNullable(NewBeaconScreen.this.primary), Optional.ofNullable(NewBeaconScreen.this.secondary), Optional.ofNullable(NewBeaconScreen.this.tertiary)));
            ((NewBeaconScreen)NewBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int beaconTier) {
            this.f_93623_ = ((NewBeaconMenu)NewBeaconScreen.this.f_97732_).hasPayment() && NewBeaconScreen.this.primary != null;
        }
    }

    public class BeaconCancelButton
    extends BeaconSpriteScreenButton {
        public BeaconCancelButton(int x, int y) {
            super(x, y, 112, 220, CommonComponents.f_130656_);
            if (BetterBeacons.config.beaconButtons.isCancelButtonTooltipEnabled) {
                if (BetterBeacons.config.beaconButtons.cancelButtonRemoveEffects) {
                    this.m_257544_(CANCEL_BUTTON_REMOVE_EFFECTS_TOOLTIP);
                } else {
                    this.m_257544_(CANCEL_BUTTON_CLOSE_CONTAINER_TOOLTIP);
                }
            }
        }

        public void m_5691_() {
            if (BetterBeacons.config.beaconButtons.cancelButtonRemoveEffects) {
                Dispatcher.sendToServer((Object)new BeaconC2SPacket(Optional.empty(), Optional.empty(), Optional.empty()));
            }
            ((NewBeaconScreen)NewBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int beaconTier) {
            this.f_93623_ = NewBeaconScreen.this.isEffectsActive && NewBeaconScreen.this.primary != null || !BetterBeacons.config.beaconButtons.cancelButtonRemoveEffects;
        }
    }

    public class BeaconPowerButton
    extends BeaconScreenButton {
        private final boolean isPrimary;
        private final boolean isSecondary;
        protected final int tier;
        private MobEffect effect;
        private TextureAtlasSprite sprite;

        public BeaconPowerButton(int x, int y, MobEffect effect, boolean isPrimary, boolean isSecondary, int tier) {
            super(x, y);
            this.isPrimary = isPrimary;
            this.isSecondary = isSecondary;
            this.tier = tier;
            this.setEffect(effect);
        }

        protected void setEffect(MobEffect effect) {
            this.effect = effect;
            this.sprite = Minecraft.m_91087_().m_91306_().m_118732_(effect);
        }

        protected MutableComponent createEffectDescription(@NotNull MobEffect effect) {
            MutableComponent component = Component.m_237115_((String)effect.m_19481_());
            if (this.isPrimary && NewBeaconScreen.this.primaryEffectAmplifier > 0) {
                component.m_130946_(" " + BBUtils.convertNumberToRoman(NewBeaconScreen.this.primaryEffectAmplifier + 1));
            }
            return component;
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                if (this.isPrimary) {
                    NewBeaconScreen.this.primary = this.effect;
                } else if (this.isSecondary) {
                    NewBeaconScreen.this.secondary = this.effect;
                } else {
                    NewBeaconScreen.this.tertiary = this.effect;
                }
                NewBeaconScreen.this.updateButtons();
            }
        }

        @Override
        protected void renderIcon(@NotNull GuiGraphics guiGraphics) {
            guiGraphics.m_280159_(this.m_252754_() + 2, this.m_252907_() + 2, 0, 18, 18, this.sprite);
        }

        @Override
        public void updateStatus(int beaconTier) {
            this.f_93623_ = this.tier < beaconTier;
            this.m_257544_(Tooltip.m_257563_((Component)this.createEffectDescription(this.effect), null));
            if (this.isPrimary) {
                this.setSelected(this.effect == NewBeaconScreen.this.primary);
            } else if (this.isSecondary) {
                this.setSelected(this.effect == NewBeaconScreen.this.secondary);
            } else {
                this.setSelected(this.effect == NewBeaconScreen.this.tertiary);
            }
        }

        @NotNull
        protected MutableComponent m_5646_() {
            return this.createEffectDescription(this.effect);
        }
    }

    public class BeaconUpgradePowerButton
    extends BeaconPowerButton {
        public BeaconUpgradePowerButton(int x, int y, MobEffect effect) {
            super(x, y, effect, false, true, 3);
        }

        @Override
        protected MutableComponent createEffectDescription(@NotNull MobEffect effect) {
            return Component.m_237115_((String)effect.m_19481_()).m_130946_(" " + BBUtils.convertNumberToRoman(NewBeaconScreen.this.primaryEffectAmplifier + 2));
        }

        @Override
        public void updateStatus(int beaconTier) {
            if (NewBeaconScreen.this.primary != null) {
                this.f_93624_ = true;
                this.setEffect(NewBeaconScreen.this.primary);
                super.updateStatus(beaconTier);
            } else {
                this.f_93624_ = false;
            }
        }
    }

    public static abstract class BeaconSpriteScreenButton
    extends BeaconScreenButton {
        private final int iconX;
        private final int iconY;

        protected BeaconSpriteScreenButton(int x, int y, int iconX, int iconY, Component component) {
            super(x, y, component);
            this.iconX = iconX;
            this.iconY = iconY;
        }

        @Override
        protected void renderIcon(@NotNull GuiGraphics guiGraphics) {
            guiGraphics.m_280218_(BEACON_TEXTURE_LOCATION, this.m_252754_() + 2, this.m_252907_() + 2, this.iconX, this.iconY, 18, 18);
        }
    }

    static abstract class BeaconScreenButton
    extends AbstractButton
    implements BeaconButton {
        private boolean selected;

        protected BeaconScreenButton(int x, int y) {
            super(x, y, 22, 22, CommonComponents.f_237098_);
        }

        protected BeaconScreenButton(int x, int y, Component message) {
            super(x, y, 22, 22, message);
        }

        public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.selected) {
                j += this.f_93618_;
            } else if (this.m_198029_()) {
                j += this.f_93618_ * 3;
            }
            guiGraphics.m_280218_(BEACON_TEXTURE_LOCATION, this.m_252754_(), this.m_252907_(), j, 219, this.f_93618_, this.f_93619_);
            this.renderIcon(guiGraphics);
        }

        protected abstract void renderIcon(GuiGraphics var1);

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void m_168797_(@NotNull NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }
}

