/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.misc;

import com.github.alexthe668.domesticationinnovation.server.misc.LanternRequest;
import com.github.alexthe668.domesticationinnovation.server.misc.RespawnRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DIWorldData
extends SavedData {
    private static final String IDENTIFIER = "domesticationinnovation_world_data";
    private final List<RespawnRequest> respawnRequestList = new ArrayList<RespawnRequest>();
    private final List<LanternRequest> lanternRequestList = new ArrayList<LanternRequest>();

    private DIWorldData() {
    }

    public static DIWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_7654_().m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            DIWorldData data = (DIWorldData)storage.m_164861_(DIWorldData::load, DIWorldData::new, IDENTIFIER);
            if (data != null) {
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public static DIWorldData load(CompoundTag nbt) {
        CompoundTag innerTag;
        int i;
        ListTag listtag;
        DIWorldData data = new DIWorldData();
        if (nbt.m_128441_("RespawnList")) {
            listtag = nbt.m_128437_("RespawnList", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.m_128728_(i);
                data.respawnRequestList.add(new RespawnRequest(innerTag.m_128461_("EntityType"), innerTag.m_128461_("DimensionIn"), innerTag.m_128469_("EntityData"), new BlockPos(innerTag.m_128451_("X"), innerTag.m_128451_("Y"), innerTag.m_128451_("Z")), innerTag.m_128454_("Timestamp"), innerTag.m_128461_("EntityNametag")));
            }
        }
        if (nbt.m_128441_("LanternList")) {
            listtag = nbt.m_128437_("LanternList", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.m_128728_(i);
                data.lanternRequestList.add(new LanternRequest(innerTag.m_128342_("PetUUID"), innerTag.m_128461_("EntityType"), innerTag.m_128342_("OwnerUUID"), new BlockPos(innerTag.m_128451_("X"), innerTag.m_128451_("Y"), innerTag.m_128451_("Z")), innerTag.m_128454_("Timestamp"), innerTag.m_128461_("EntityNametag")));
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag tag;
        ListTag listTag;
        if (!this.respawnRequestList.isEmpty()) {
            listTag = new ListTag();
            for (RespawnRequest respawnRequest : this.respawnRequestList) {
                tag = new CompoundTag();
                tag.m_128359_("EntityType", respawnRequest.getEntityTypeLoc());
                tag.m_128359_("DimensionIn", respawnRequest.getDimension());
                tag.m_128365_("EntityData", (Tag)respawnRequest.getEntityData());
                tag.m_128405_("X", respawnRequest.getBedPosition().m_123341_());
                tag.m_128405_("Y", respawnRequest.getBedPosition().m_123342_());
                tag.m_128405_("Z", respawnRequest.getBedPosition().m_123343_());
                tag.m_128356_("Timestamp", respawnRequest.getTimestamp());
                tag.m_128359_("EntityNametag", respawnRequest.getNametag());
                listTag.add((Object)tag);
            }
            compound.m_128365_("RespawnList", (Tag)listTag);
        }
        if (!this.lanternRequestList.isEmpty()) {
            listTag = new ListTag();
            for (LanternRequest lanternRequest : this.lanternRequestList) {
                tag = new CompoundTag();
                tag.m_128362_("PetUUID", lanternRequest.getPetUUID());
                tag.m_128359_("EntityType", lanternRequest.getEntityTypeLoc());
                tag.m_128362_("OwnerUUID", lanternRequest.getOwnerUUID());
                tag.m_128356_("Timestamp", lanternRequest.getTimestamp());
                tag.m_128359_("EntityNametag", lanternRequest.getNametag());
                tag.m_128405_("X", lanternRequest.getChunkPosition().m_123341_());
                tag.m_128405_("Y", lanternRequest.getChunkPosition().m_123342_());
                tag.m_128405_("Z", lanternRequest.getChunkPosition().m_123343_());
                listTag.add((Object)tag);
            }
            compound.m_128365_("LanternList", (Tag)listTag);
        }
        return compound;
    }

    public void addRespawnRequest(RespawnRequest request) {
        this.respawnRequestList.add(request);
    }

    public void removeRespawnRequest(RespawnRequest request) {
        this.respawnRequestList.remove(request);
    }

    public List<RespawnRequest> getRespawnRequestsFor(Level level, BlockPos pos) {
        ArrayList<RespawnRequest> list = new ArrayList<RespawnRequest>();
        String dimension = level.m_46472_().toString();
        for (RespawnRequest request : this.respawnRequestList) {
            if (!dimension.equals(request.getDimension()) || !pos.equals((Object)request.getBedPosition())) continue;
            list.add(request);
        }
        return list;
    }

    public void addLanternRequest(LanternRequest request) {
        this.lanternRequestList.add(request);
    }

    public void removeLanternRequest(LanternRequest request) {
        this.lanternRequestList.remove(request);
    }

    public void removeMatchingLanternRequests(UUID reloaded) {
        this.lanternRequestList.removeIf(request -> request.getPetUUID().equals(reloaded));
    }

    public List<LanternRequest> getLanternRequestsFor(UUID uuid) {
        ArrayList<LanternRequest> list = new ArrayList<LanternRequest>();
        for (LanternRequest request : this.lanternRequestList) {
            if (!uuid.equals(request.getOwnerUUID())) continue;
            list.add(request);
        }
        return list;
    }
}

