/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries;

import com.li64.tide.Tide;
import com.li64.tide.data.loot.BiomeTagPredicate;
import com.li64.tide.data.loot.BlockNearbyPredicate;
import com.li64.tide.data.loot.IsNightPredicate;
import com.li64.tide.data.loot.LootCrateBlockPredicate;
import com.li64.tide.data.loot.MoonPhasePredicate;
import java.util.HashMap;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class TideLootConditions {
    public static final HashMap<String, LootItemConditionType> LOOT_CONDITIONS = new HashMap();
    public static final LootItemConditionType BIOME_TAG_CHECK = TideLootConditions.register("check_biome_tag", new LootItemConditionType((Serializer)new BiomeTagPredicate.Serializer()));
    public static final LootItemConditionType MOON_PHASE = TideLootConditions.register("check_moon_phase", new LootItemConditionType((Serializer)new MoonPhasePredicate.Serializer()));
    public static final LootItemConditionType IS_NIGHT = TideLootConditions.register("is_night", new LootItemConditionType((Serializer)new IsNightPredicate.Serializer()));
    public static final LootItemConditionType BLOCK_NEARBY = TideLootConditions.register("block_nearby", new LootItemConditionType((Serializer)new BlockNearbyPredicate.Serializer()));
    public static final LootItemConditionType LOOT_CRATE_BLOCK = TideLootConditions.register("loot_crate_block", new LootItemConditionType((Serializer)new LootCrateBlockPredicate.Serializer()));

    public static LootItemConditionType register(String key, LootItemConditionType type) {
        LOOT_CONDITIONS.put(key, type);
        return type;
    }

    public static void init() {
        LOOT_CONDITIONS.forEach(Tide.PLATFORM::registerLootCondition);
    }
}

