/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.li64.tide.Tide;
import com.li64.tide.data.rods.BaitContents;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClientFishingRodTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation SLOT_BACKGROUND_SPRITE = Tide.resource("textures/gui/sprites/container/bait/slot_background.png");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = Tide.resource("textures/gui/sprites/container/bait/slot_highlight_front.png");
    private static final Component MESSAGE = Component.m_237115_((String)"text.tide.rod_tooltip.bait_desc");
    private static final int OFFSET_Y = 10;
    private static final int MARGIN_Y = 4;
    private static final int BG_BORDER = 1;
    private static final int SLOT_SIZE_X = 20;
    private static final int SLOT_SIZE_Y = 20;
    private final BaitContents contents;

    public ClientFishingRodTooltip(BaitContents pContents) {
        this.contents = pContents;
    }

    public int m_142103_() {
        return this.backgroundHeight() + 4 + 10;
    }

    public int m_142069_(@NotNull Font font) {
        return Math.max(this.backgroundWidth(), font.m_92852_((FormattedText)MESSAGE));
    }

    private int backgroundWidth() {
        return this.gridWidth() * 20 + 2;
    }

    private int backgroundHeight() {
        return 22;
    }

    public void m_183452_(@NotNull Font font, int x, int y, @NotNull GuiGraphics graphics) {
        int gridWidth = this.gridWidth();
        graphics.m_280430_(font, MESSAGE, x, y, DyeColor.LIGHT_GRAY.m_41071_());
        for (int i = 0; i < gridWidth; ++i) {
            int dspX = x + i * 20 + 1;
            int dspY = y + 1 + 10;
            this.renderSlot(dspX, dspY, i, graphics, font);
        }
    }

    private void renderSlot(int x, int y, int index, GuiGraphics graphics, Font font) {
        graphics.m_280163_(SLOT_BACKGROUND_SPRITE, x - 4 + 1, y - 4 + 1, 0.0f, 0.0f, 24, 24, 24, 24);
        if (index >= this.contents.size()) {
            return;
        }
        ItemStack stack = this.contents.items().get(index);
        graphics.m_280256_(stack, x + 1, y + 1, index);
        graphics.m_280370_(font, stack, x + 1, y + 1);
        RenderSystem.enableBlend();
        if (index == 0) {
            graphics.m_280163_(SLOT_HIGHLIGHT_FRONT_SPRITE, x - 4 + 1, y - 4 + 1, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        RenderSystem.disableBlend();
    }

    private int gridWidth() {
        return Math.max(3, (int)Math.ceil(Math.sqrt((double)this.contents.size() + 1.0)));
    }
}

