/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BaitContents
implements TooltipComponent {
    public static final int MAX_STACKS = 3;
    private final List<ItemStack> items;

    public BaitContents() {
        this(List.of());
    }

    public BaitContents(List<ItemStack> items) {
        this.items = items;
    }

    public List<ItemStack> items() {
        return this.items;
    }

    public ItemStack get(int index) {
        return this.items().get(index);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public String toString() {
        return "BaitContents" + String.valueOf(this.items);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("size", this.size());
        for (int i = 0; i < this.size(); ++i) {
            tag.m_128365_("item-" + i, (Tag)this.items.get(i).m_41739_(new CompoundTag()));
        }
        return tag;
    }

    public static BaitContents fromNbt(CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return new BaitContents();
        }
        ImmutableList.Builder itemsBuilder = ImmutableList.builder();
        int size = tag.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            itemsBuilder.add((Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("item-" + i)));
        }
        return new BaitContents((List<ItemStack>)itemsBuilder.build());
    }

    public static class Mutable {
        private final List<ItemStack> items;

        public Mutable(BaitContents contents) {
            this.items = contents == null ? new ArrayList<ItemStack>() : new ArrayList<ItemStack>(contents.items);
        }

        private int findStackIndex(ItemStack stack) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!ItemStack.m_150942_((ItemStack)this.items.get(i), (ItemStack)stack)) continue;
                return i;
            }
            return -1;
        }

        public void tryInsert(ItemStack stack) {
            if (!stack.m_41619_() && stack.m_41720_().m_142095_()) {
                int index = this.findStackIndex(stack);
                int count = stack.m_41613_();
                if (index != -1 && stack.m_41753_()) {
                    ItemStack current = this.items.get(index);
                    int stackSize = stack.m_41741_();
                    int amountToAdd = Math.min(stackSize - current.m_41613_(), stack.m_41613_());
                    ItemStack added = current.m_255036_(current.m_41613_() + amountToAdd);
                    stack.m_41774_(amountToAdd);
                    this.items.set(index, added);
                } else if (this.items.size() < 3) {
                    this.items.add(stack.m_41620_(count));
                }
            }
        }

        public void tryTransfer(Slot slot, Player pPlayer) {
            ItemStack slotStack = slot.m_150647_(slot.m_7993_().m_41613_(), slot.m_6641_(), pPlayer);
            this.tryInsert(slotStack);
            if (!slotStack.m_41619_()) {
                slot.m_150659_(slotStack);
            }
        }

        @Nullable
        public ItemStack removeStack() {
            if (this.items.isEmpty()) {
                return null;
            }
            return this.items.remove(0).m_41777_();
        }

        public void shrinkStack(ItemStack stack) {
            int index = this.findStackIndex(stack);
            if (index == -1) {
                return;
            }
            this.items.get(index).m_41774_(1);
            if (this.items.get(index).m_41619_()) {
                this.items.remove(index);
            }
        }

        public BaitContents toImmutable() {
            return new BaitContents(List.copyOf(this.items));
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }
}

