/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.minigame;

import com.li64.tide.Tide;
import com.li64.tide.network.messages.MinigameClientMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class FishCatchMinigame {
    private static final int SERVER_DELAY_MILLIS = 200;
    private static final ArrayList<FishCatchMinigame> ACTIVE_MINIGAMES = new ArrayList();
    private static final HashMap<ServerPlayer, Long> ACTIVE_DELAYS = new HashMap();
    private final TideFishingHook hook;
    private final ServerPlayer player;

    public static FishCatchMinigame getInstance(Player player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return minigame;
        }
        return null;
    }

    public static FishCatchMinigame create(Player player) {
        FishCatchMinigame existingInstance = FishCatchMinigame.getInstance(player);
        if (existingInstance != null) {
            return existingInstance;
        }
        FishCatchMinigame minigame = new FishCatchMinigame((ServerPlayer)player);
        ACTIVE_MINIGAMES.add(minigame);
        return minigame;
    }

    public static boolean minigameActive(Player player) {
        for (FishCatchMinigame minigame : ACTIVE_MINIGAMES) {
            if (minigame.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    protected FishCatchMinigame(ServerPlayer player) {
        this.player = player;
        this.hook = Objects.requireNonNull(HookAccessor.getHook((Player)player));
        this.hook.setMinigameActive(true);
        float strength = TideUtils.getHighestStrength(this.hook.getHookedItems());
        if (this.hook.getHook().m_150930_(TideItems.IRON_FISHING_HOOK)) {
            strength *= 0.89f;
        }
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(0, strength), player);
    }

    public static boolean delayActive(ServerPlayer player) {
        if (!ACTIVE_DELAYS.containsKey(player)) {
            return false;
        }
        if (System.currentTimeMillis() > ACTIVE_DELAYS.get(player)) {
            ACTIVE_DELAYS.remove(player);
            return false;
        }
        return true;
    }

    private ServerPlayer getPlayer() {
        return this.player;
    }

    public void onFinish() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.hook.setMinigameActive(false);
        Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
        ACTIVE_MINIGAMES.remove(this);
        ACTIVE_DELAYS.put(this.player, System.currentTimeMillis() + 200L);
    }

    public void onTimeout() {
        if (this.cancelIfNecessary()) {
            return;
        }
        this.onFinish();
    }

    public void onFail() {
        if (this.cancelIfNecessary()) {
            return;
        }
        if (Tide.CONFIG.minigame.doFailSound) {
            this.hook.m_9236_().m_5594_(null, this.hook.getPlayerOwner().m_20183_(), SoundEvents.f_12344_, SoundSource.AMBIENT, 0.9f, 1.0f);
        }
        this.hook.invalidateCatch();
        this.hook.retrieve();
        this.onFinish();
    }

    public void onWin() {
        if (this.cancelIfNecessary()) {
            return;
        }
        if (Tide.CONFIG.minigame.doSuccessSound) {
            this.hook.m_9236_().m_5594_(null, this.hook.getPlayerOwner().m_20183_(), SoundEvents.f_11871_, SoundSource.AMBIENT, 0.15f, 1.0f);
        }
        this.hook.retrieve();
        this.onFinish();
    }

    public boolean cancelIfNecessary() {
        if (this.hook == null || this.player == null) {
            Tide.NETWORK.sendToPlayer(new MinigameClientMsg(2), this.player);
            ACTIVE_MINIGAMES.remove(this);
            return true;
        }
        return false;
    }

    public void handleClientEvent(byte event) {
        this.cancelIfNecessary();
        switch (event) {
            case 0: {
                this.onTimeout();
                break;
            }
            case 1: {
                this.onFail();
                break;
            }
            case 2: {
                this.onWin();
            }
        }
    }
}

