/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.li64.tide.registries.TideLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record LootCrateBlockPredicate(Block block) implements LootItemCondition
{
    public static final MapCodec<LootCrateBlockPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("block").forGetter(LootCrateBlockPredicate::block)).apply((Applicative)instance, LootCrateBlockPredicate::new));

    public static LootItemCondition.Builder matches(Block block) {
        return () -> new LootCrateBlockPredicate(block);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return TideLootConditions.LOOT_CRATE_BLOCK;
    }

    public boolean test(LootContext context) {
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        return blockState != null && blockState.m_60713_(this.block);
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return Set.of(LootContextParams.f_81461_);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootCrateBlockPredicate> {
        public void serialize(JsonObject jsonObject, LootCrateBlockPredicate predicate, @NotNull JsonSerializationContext context) {
            jsonObject.addProperty("block", BuiltInRegistries.f_256975_.m_7981_((Object)predicate.block()).toString());
        }

        @NotNull
        public LootCrateBlockPredicate deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            ResourceLocation location = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
            return new LootCrateBlockPredicate((Block)BuiltInRegistries.f_256975_.m_7745_(location));
        }
    }
}

