/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ReadProfileMsg;
import com.li64.tide.registries.TideSoundEvents;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FishingJournalScreen
extends Screen {
    private static final int SLOT_SIZE = 22;
    private static final int SLOT_MARGIN = 4;
    private static final ResourceLocation PROFILE_BG = Tide.resource("textures/gui/journal/journal_profile.png");
    private int numRows;
    private int numCols;
    private int totalSlots;
    private ArrayList<JournalPage> pages;
    public ItemStack profileFish = null;
    public JournalLayout.Profile profileConfig = null;
    public int page;
    public Player player;

    public FishingJournalScreen(Player player) {
        super(GameNarrator.f_93310_);
        this.player = player;
        this.loadJournalPages();
        this.m_7856_();
        player.m_5496_(TideSoundEvents.JOURNAL_OPEN, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    public boolean m_7043_() {
        return false;
    }

    private void loadJournalPages() {
        try {
            this.pages = new ArrayList();
            Tide.JOURNAL.getPageConfigs().stream().map(JournalPage::new).forEach(page -> this.pages.add((JournalPage)page));
        }
        catch (Exception e) {
            Tide.LOG.error("Exception in loading journal pages: {}, {}", (Object)e.getMessage(), (Object)e.getCause());
        }
        this.pages.removeIf(journalPage -> !TidePlayerData.CLIENT_DATA.hasPageUnlocked((JournalPage)journalPage));
        if (this.pages.size() > 1) {
            this.pages.remove(0);
        }
    }

    private void nextPage(int page) {
        this.m_169413_();
        this.page = page;
        this.m_7856_();
        this.player.m_5496_(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    protected void m_7856_() {
        this.totalSlots = this.getPage().getAllProfiles().size();
        this.numCols = this.calculateNumCols(this.totalSlots);
        this.numRows = this.calculateNumRows(this.totalSlots);
        this.m_169413_();
        if (this.profileFish != null) {
            this.createProfileControls();
        } else {
            this.createMenuControls();
            this.createFishIcons();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.player.m_5496_(TideSoundEvents.JOURNAL_CLOSE, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    private void createFishIcons() {
        int startX = (this.f_96543_ - this.getTotalWidth()) / 2;
        int startY = (this.f_96544_ - this.getTotalHeight()) / 2;
        List<JournalLayout.Profile> profiles = this.getPage().getAllProfiles();
        for (int i = 0; i < this.totalSlots && i < profiles.size(); ++i) {
            int row = i / this.numCols;
            int col = i % this.numCols;
            int x = startX + col * 26;
            int y = startY + row * 26 - 26;
            JournalLayout.Profile profile = profiles.get(i);
            if (profile.getFish().m_41619_()) continue;
            this.m_142416_((GuiEventListener)new FishButton(x, y, 22, 22, profile, this));
        }
    }

    private JournalPage getPage() {
        return this.pages.get(this.page);
    }

    private int calculateNumRows(int slots) {
        return Mth.m_14167_((float)((float)slots / (float)this.numCols));
    }

    private int calculateNumCols(int slots) {
        return Math.min(12, slots);
    }

    private int getTotalWidth() {
        return this.numCols * 26 - 4;
    }

    private int getTotalHeight() {
        return this.numRows * 26 - 4;
    }

    private void createMenuControls() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 80, this.f_96544_ - 40, 160, 18).m_253136_());
        Button rightButton = Button.m_253074_((Component)Component.m_237113_((String)"<<"), button -> this.pageLeft()).m_252987_(this.f_96543_ / 2 - 110, this.f_96544_ - 40, 26, 18).m_253136_();
        rightButton.f_93623_ = this.page > 0;
        this.m_142416_((GuiEventListener)rightButton);
        Button leftButton = Button.m_253074_((Component)Component.m_237113_((String)">>"), button -> this.pageRight()).m_252987_(this.f_96543_ / 2 + 84, this.f_96544_ - 40, 26, 18).m_253136_();
        leftButton.f_93623_ = this.page < this.pages.size() - 1;
        this.m_142416_((GuiEventListener)leftButton);
    }

    private void createProfileControls() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.closeProfile()).m_252987_(this.f_96543_ / 2 - 80, this.f_96544_ - 40, 160, 18).m_253136_());
    }

    private void closeProfile() {
        this.profileConfig = null;
        this.profileFish = null;
        this.m_7856_();
        this.player.m_5496_(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    public void pageLeft() {
        if (this.page > 0) {
            this.nextPage(this.page - 1);
        }
    }

    public void pageRight() {
        if (this.page < this.pages.size() - 1) {
            this.nextPage(this.page + 1);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.profileFish == null) {
            MutableComponent title = Component.m_237115_((String)this.getPage().title());
            MutableComponent content = Component.m_237115_((String)this.getPage().content());
            List formattedContent = this.f_96547_.m_92923_((FormattedText)content, 300);
            int titleX = (this.f_96543_ - this.f_96547_.m_92852_((FormattedText)title)) / 2;
            int titleY = 30;
            int contentX = (this.f_96543_ - 300) / 2;
            int contentY = this.f_96544_ - 90;
            graphics.m_280488_(this.f_96547_, title.getString(), titleX, titleY, 0xFFFFFF);
            for (int i = 0; i < formattedContent.size(); ++i) {
                graphics.m_280648_(this.f_96547_, (FormattedCharSequence)formattedContent.get(i), contentX, contentY + 10 * i, 0xFFFFFF);
            }
        } else {
            this.renderProfile(graphics);
        }
    }

    public void openProfile(JournalLayout.Profile profile) {
        this.profileConfig = profile;
        this.profileFish = ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(profile.fishItem()))).m_7968_();
        this.player.m_5496_(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
        Tide.NETWORK.sendToServer(new ReadProfileMsg(this.profileFish));
        this.m_7856_();
    }

    public void renderProfile(GuiGraphics graphics) {
        FormattedCharSequence charSequence;
        int i;
        int bgWidth = 291;
        int bgHeight = 202;
        int offsetY = 20;
        graphics.m_280163_(PROFILE_BG, (this.f_96543_ - bgWidth) / 2, (this.f_96544_ - bgHeight) / 2 - offsetY, 0.0f, 0.0f, bgWidth, bgHeight, bgWidth, bgHeight);
        Style underlined = Component.m_237119_().m_7383_().m_131162_(Boolean.valueOf(true));
        MutableComponent descriptionRaw = Component.m_237115_((String)this.profileConfig.description());
        MutableComponent locationTitleRaw = Component.m_237115_((String)"profile.info.location").m_130948_(underlined);
        MutableComponent locationRaw = Component.m_237115_((String)("profile.info.location." + this.profileConfig.location()));
        MutableComponent climateTitleRaw = Component.m_237115_((String)"profile.info.climate").m_130948_(underlined);
        MutableComponent climateRaw = Component.m_237115_((String)("profile.info.climate." + this.profileConfig.climate()));
        List description = this.f_96547_.m_92923_((FormattedText)descriptionRaw, 114);
        boolean isDescriptionEmpty = descriptionRaw.getString().isEmpty() || descriptionRaw.getString().contains("profile.item.");
        ArrayList location = new ArrayList();
        location.addAll(this.f_96547_.m_92923_((FormattedText)locationTitleRaw, 114));
        location.addAll(this.f_96547_.m_92923_((FormattedText)locationRaw, 114));
        ArrayList climate = new ArrayList();
        climate.addAll(this.f_96547_.m_92923_((FormattedText)climateTitleRaw, 114));
        climate.addAll(this.f_96547_.m_92923_((FormattedText)climateRaw, 114));
        Component fishName = TideUtils.removeRawTextInName(this.profileFish.m_41786_());
        float scaleAmount = 2.0f;
        int titleX = (this.f_96543_ - this.f_96547_.m_92852_((FormattedText)fishName) - bgWidth / 2) / 2;
        int imageX = (int)(((float)this.f_96543_ - 16.0f * scaleAmount - (float)(bgWidth / 2)) / 2.0f);
        int leftContentX = (this.f_96543_ - bgWidth / 2) / 2;
        int rightContentX = (this.f_96543_ + bgWidth / 2) / 2;
        int rightTop = (this.f_96544_ - 204) / 2 - 6;
        int leftTop = rightTop + (isDescriptionEmpty ? 55 : 0);
        graphics.m_280614_(this.f_96547_, fishName, titleX, leftTop, 0, false);
        if (!isDescriptionEmpty) {
            for (i = 0; i < description.size(); ++i) {
                graphics.m_280649_(this.f_96547_, (FormattedCharSequence)description.get(i), leftContentX - 56, leftTop + 46 + 11 * i, 0, false);
            }
        }
        for (i = 0; i < location.size(); ++i) {
            charSequence = (FormattedCharSequence)location.get(i);
            graphics.m_280649_(this.f_96547_, charSequence, rightContentX - this.f_96547_.m_92724_(charSequence) / 2, rightTop + 46 + 11 * i, 0, false);
        }
        for (i = 0; i < climate.size(); ++i) {
            charSequence = (FormattedCharSequence)climate.get(i);
            graphics.m_280649_(this.f_96547_, charSequence, rightContentX - this.f_96547_.m_92724_(charSequence) / 2, rightTop + 86 + 11 * i, 0, false);
        }
        graphics.m_280168_().m_85841_(scaleAmount, scaleAmount, scaleAmount);
        graphics.m_280480_(this.profileFish, (int)((float)imageX / scaleAmount), (int)((float)(leftTop + 11) / scaleAmount));
        graphics.m_280168_().m_85841_(1.0f / scaleAmount, 1.0f / scaleAmount, 1.0f / scaleAmount);
    }

    public static class FishButton
    extends AbstractButton {
        private static final ResourceLocation slotTex = Tide.resource("textures/gui/journal/fish_border.png");
        private static final ResourceLocation slotHoverTex = Tide.resource("textures/gui/journal/fish_border_select.png");
        private static final ResourceLocation unreadTex = Tide.resource("textures/gui/journal/unread_icon.png");
        private static final ResourceLocation unreadHoverTex = Tide.resource("textures/gui/journal/unread_icon_select.png");
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final JournalLayout.Profile profile;
        private final FishingJournalScreen parent;

        public FishButton(int x, int y, int w, int h, JournalLayout.Profile profile, FishingJournalScreen parent) {
            super(x, y, w, h, GameNarrator.f_93310_);
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.profile = profile;
            this.parent = parent;
        }

        public void m_5691_() {
            if (TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.profile.getFish())) {
                this.parent.openProfile(this.profile);
            }
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            ResourceLocation unreadTexture;
            ResourceLocation texture = this.m_5953_(mouseX, mouseY) ? slotHoverTex : slotTex;
            graphics.m_280163_(texture, this.x, this.y, 0.0f, 0.0f, this.w, this.h, this.w, this.h);
            if (!this.profile.getFish().m_41619_()) {
                if (!TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.profile.getFish())) {
                    graphics.m_280246_(0.0f, 0.0f, 0.0f, 1.0f);
                }
                graphics.m_280480_(this.profile.getFish(), this.x + 3, this.y + 3);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!Tide.CONFIG.general.showUnread) {
                return;
            }
            ResourceLocation resourceLocation = unreadTexture = this.m_5953_(mouseX, mouseY) ? unreadHoverTex : unreadTex;
            if (TidePlayerData.CLIENT_DATA.isUnread(this.profile)) {
                graphics.m_280163_(unreadTexture, this.x - 1, this.y - 1, 0.0f, 0.0f, 7, 7, 7, 7);
            }
        }

        protected void m_168797_(@NotNull NarrationElementOutput output) {
        }
    }
}

