/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.overlays;

import com.li64.tide.Tide;
import com.li64.tide.network.messages.MinigameServerMsg;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class CatchMinigameOverlay {
    private static final int INIT_DELAY_MILLIS = 400;
    private static final ResourceLocation BAR_BG_TEX = Tide.resource("textures/gui/fishing/catch_bar_bg.png");
    private static final ResourceLocation MARKER_TEX = Tide.resource("textures/gui/fishing/catch_marker.png");
    private static final ResourceLocation SELECT_TEX = Tide.resource("textures/gui/fishing/catch_marker_select.png");
    private static float timeLeft = 80.0f;
    private static float animProgress = 0.0f;
    private static float timer = 20.0f;
    private static boolean isActive = false;
    private static MutableComponent accuracyText = null;
    private static ChatFormatting textColor = ChatFormatting.WHITE;
    private static float fishStrength;
    private static long delayTime;
    private static final float DEFAULT_SPEED = 0.12f;

    public static void start(float strength) {
        if (isActive) {
            return;
        }
        fishStrength = strength;
        accuracyText = null;
        animProgress = new Random().nextFloat() * 100.0f;
        timeLeft = 0.0f;
        timer = 0.0f;
        isActive = true;
        delayTime = System.currentTimeMillis() + 400L;
    }

    public static void interact() {
        if (!isActive || System.currentTimeMillis() < delayTime) {
            return;
        }
        float accuracy = Math.abs(Mth.m_14031_((float)(animProgress * CatchMinigameOverlay.getSpeed())));
        String accuracyKey = "minigame.rating.trash";
        float catchChance = 0.0f;
        textColor = ChatFormatting.BLACK;
        if (accuracy < 0.05f) {
            accuracyKey = "minigame.rating.perfect";
            catchChance = 1.0f;
            textColor = ChatFormatting.GOLD;
        } else if (accuracy < 0.15f) {
            accuracyKey = "minigame.rating.great";
            catchChance = 1.0f;
            textColor = ChatFormatting.GREEN;
        } else if (accuracy < 0.3f) {
            accuracyKey = "minigame.rating.good";
            catchChance = 0.95f;
            textColor = ChatFormatting.DARK_GREEN;
        } else if (accuracy < 0.45f) {
            accuracyKey = "minigame.rating.ok";
            catchChance = 0.5f;
            textColor = ChatFormatting.YELLOW;
        } else if (accuracy < 0.6f) {
            accuracyKey = "minigame.rating.bad";
            catchChance = 0.4f;
            textColor = ChatFormatting.RED;
        } else if (accuracy < 0.78f) {
            accuracyKey = "minigame.rating.terrible";
            catchChance = 0.1f;
            textColor = ChatFormatting.DARK_RED;
        }
        accuracyText = Component.m_237115_((String)accuracyKey);
        Random random = new Random();
        if (random.nextFloat() < catchChance) {
            Tide.NETWORK.sendToServer(new MinigameServerMsg(2));
        } else {
            Tide.NETWORK.sendToServer(new MinigameServerMsg(1));
        }
        CatchMinigameOverlay.close();
    }

    public static void close() {
        isActive = false;
        timer = 0.0f;
    }

    public static float getSpeed() {
        return (fishStrength * 0.048f + 0.12f) * (float)Tide.CONFIG.minigame.minigameDifficulty;
    }

    public static void render(GuiGraphics graphics, float partialTick) {
        float delta = Minecraft.m_91087_().m_91297_();
        if (timer >= 20.0f) {
            return;
        }
        if (!isActive) {
            timer += delta;
        } else {
            animProgress += delta;
            if ((timeLeft += delta) >= 80.0f || HookAccessor.bobberRemoved((Player)Minecraft.m_91087_().f_91074_)) {
                CatchMinigameOverlay.close();
                Tide.NETWORK.sendToServer(new MinigameServerMsg(0));
            }
        }
        float alpha = -Mth.m_14036_((float)((timer - 10.0f) / 10.0f), (float)0.0f, (float)1.0f) + 1.0f;
        int texWidth = 36;
        int texHeight = 16;
        int x = (graphics.m_280182_() - texWidth) / 2;
        int y = graphics.m_280206_() / 2 - texHeight - 6;
        int markerX = (int)((float)x + Mth.m_14031_((float)(animProgress * CatchMinigameOverlay.getSpeed())) * ((float)texWidth / 2.0f - 2.0f));
        ResourceLocation markerTexture = timer % 4.0f < 2.0f ? MARKER_TEX : SELECT_TEX;
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        graphics.m_280163_(BAR_BG_TEX, x, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        graphics.m_280163_(markerTexture, markerX, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        if (!Tide.CONFIG.minigame.doFeedback || accuracyText == null) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, (Component)accuracyText.m_130948_(accuracyText.m_7383_().m_131140_(textColor)), (graphics.m_280182_() - font.m_92852_((FormattedText)accuracyText)) / 2, y - 10, 0, false);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static boolean isActive() {
        return isActive;
    }
}

