/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide;

import com.google.common.collect.ImmutableBiMap;
import com.li64.tide.config.TideConfig;
import com.li64.tide.data.TideDataLoader;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.journal.config.CustomPageLoader;
import com.li64.tide.data.journal.config.CustomProfileLoader;
import com.li64.tide.data.journal.config.CustomRemovalLoader;
import com.li64.tide.data.loot.FishingStatsPredicate;
import com.li64.tide.data.loot.TideFishingPredicate;
import com.li64.tide.data.loot.TornNoteData;
import com.li64.tide.data.rods.AccessoryData;
import com.li64.tide.data.rods.AccessoryDataLoader;
import com.li64.tide.data.rods.BaitData;
import com.li64.tide.data.rods.BaitDataLoader;
import com.li64.tide.network.TideMessages;
import com.li64.tide.platform.Services;
import com.li64.tide.platform.services.TideMainPlatform;
import com.li64.tide.platform.services.TideNetworkPlatform;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.items.TornNoteItem;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tide {
    public static final String MOD_ID = "tide";
    public static final String MOD_NAME = "Tide";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Tide");
    public static final TideMainPlatform PLATFORM = Services.load(TideMainPlatform.class);
    public static final TideNetworkPlatform NETWORK = Services.load(TideNetworkPlatform.class);
    private static final ArrayList<TideDataLoader<?>> LOADERS = new ArrayList();
    public static TideConfig CONFIG;
    public static JournalLayout JOURNAL;
    public static TideDataLoader<BaitData> BAIT_DATA;
    public static TideDataLoader<AccessoryData> ACCESSORY_DATA;
    public static TideDataLoader<JournalLayout.Page> PAGE_DATA;
    public static TideDataLoader<JournalLayout.Profile> PROFILE_DATA;
    public static TideDataLoader<CustomRemovalLoader.Removal> REMOVAL_DATA;

    private static <T> TideDataLoader<T> registerDataLoader(TideDataLoader<T> loader) {
        LOADERS.add(loader);
        return loader;
    }

    public static void init() {
        CONFIG = (TideConfig)AutoConfig.register(TideConfig.class, Toml4jConfigSerializer::new).getConfig();
        TideMessages.init(NETWORK);
        LOG.info("Initialized Tide mod on {}", (Object)PLATFORM.getPlatformName());
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static CreativeModeTab.Builder getCreativeTab(CreativeModeTab.Builder builder) {
        return builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.tide.main")).m_257737_(() -> new ItemStack((ItemLike)TideItems.ANGELFISH)).m_257501_(Tide::displayItems);
    }

    public static void displayItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        TideItems.getCreativeModeItemList().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        TornNoteData.INSTANCES.forEach(instance -> output.m_246342_(TornNoteItem.create(instance)));
    }

    public static void onRegisterReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        LOADERS.forEach((Consumer<TideDataLoader<?>>)((Consumer<TideDataLoader>)loader -> registry.accept(loader.getDirectory(), (PreparableReloadListener)loader)));
    }

    public static LootPoolEntryContainer.Builder<?> getCrateFishingEntry() {
        return LootTableReference.m_79776_((ResourceLocation)TideLootTables.Fishing.Crates.BLOCK).m_79707_(Tide.CONFIG.general.crateWeight).m_79711_(Tide.CONFIG.general.crateQuality).m_79080_((LootItemCondition.Builder)LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)FishingHookPredicate.m_39766_((boolean)true))).m_285888_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)TideFishingPredicate.isLavaFishing(true)))).m_285747_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_(TideEntityTypes.FISHING_BOBBER)))));
    }

    static {
        BAIT_DATA = Tide.registerDataLoader(new BaitDataLoader());
        ACCESSORY_DATA = Tide.registerDataLoader(new AccessoryDataLoader());
        PAGE_DATA = Tide.registerDataLoader(new CustomPageLoader());
        PROFILE_DATA = Tide.registerDataLoader(new CustomProfileLoader());
        REMOVAL_DATA = Tide.registerDataLoader(new CustomRemovalLoader());
        EntitySubPredicate.Types.f_218854_ = ImmutableBiMap.builder().putAll((Map)EntitySubPredicate.Types.f_218854_).put((Object)"tide_fishing", TideFishingPredicate::fromJson).put((Object)"fishing_stats", FishingStatsPredicate::fromJson).build();
    }
}

