/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionAccessor;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ReflectionException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ObjectFieldCopier {
    public static void copyAllFields(Object source, Object target, Class<?> clazz) {
        if (source == null || target == null) {
            throw new NullPointerException("Source and target objects cannot be null");
        }
        Set<Field> sourceFields = ObjectFieldCopier.getAllFields(source.getClass());
        Set<Field> targetFields = ObjectFieldCopier.getAllFields(target.getClass());
        MethodHandles.Lookup privateLookup = ReflectionAccessor.privateLookup(clazz);
        for (Field sourceField : sourceFields) {
            Field targetField = ObjectFieldCopier.findCorrespondingField(sourceField, targetFields);
            if (targetField == null || !ObjectFieldCopier.areFieldsCompatible(sourceField, targetField)) continue;
            ObjectFieldCopier.copyField(source, target, sourceField, targetField, privateLookup);
        }
    }

    private static Set<Field> getAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
        }
        return fields;
    }

    private static Field findCorrespondingField(Field sourceField, Set<Field> targetFields) {
        for (Field targetField : targetFields) {
            if (!targetField.getName().equals(sourceField.getName())) continue;
            return targetField;
        }
        return null;
    }

    private static boolean areFieldsCompatible(Field sourceField, Field targetField) {
        return targetField.getType().isAssignableFrom(sourceField.getType());
    }

    private static void copyField(Object source, Object target, Field sourceField, Field targetField, MethodHandles.Lookup privateLookup) {
        if (Modifier.isFinal(targetField.getModifiers())) {
            return;
        }
        try {
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            targetField.set(target, sourceField.get(source));
        }
        catch (Exception e) {
            System.err.println("Error copying field: " + sourceField.getName() + " - " + e.getMessage());
            throw new ReflectionException(e);
        }
    }
}

