/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.StartupProgressBar;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.CSB;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefRenderElement;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefSimpleFont;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.TextureRenderer;
import net.minecraftforge.fml.earlydisplay.ElementShader;
import net.minecraftforge.fml.earlydisplay.QuadHelper;
import net.minecraftforge.fml.earlydisplay.RenderElement;
import net.minecraftforge.fml.earlydisplay.SimpleBufferBuilder;
import net.minecraftforge.fml.earlydisplay.SimpleFont;

public class ProgressBar {
    public static final int BAR_HEIGHT = 20;
    public static final int BAR_WIDTH = 400;
    protected final int fontTextureId;
    protected final SimpleFont font;

    public ProgressBar(SimpleFont font) {
        this.font = font;
        RefSimpleFont fontAccessor = new RefSimpleFont(font);
        this.fontTextureId = fontAccessor.textureNumber();
    }

    public static TextureRenderer progressBar(int[] position, ColorFunction colourFunction, ProgressDisplay progressDisplay) {
        return (csb, frame) -> {
            RenderElement.DisplayContext context = csb.ctx();
            SimpleBufferBuilder bb = csb.buffer();
            int colour = colourFunction.color(frame);
            int alpha = (colour & 0xFF000000) >> 24;
            context.elementShader().updateTextureUniform(0);
            context.elementShader().updateRenderTypeUniform(ElementShader.RenderType.BAR);
            float[] progress = progressDisplay.progress(frame);
            bb.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
            int inset = 2;
            int x0 = position[0];
            int x1 = position[2] + 4 * inset;
            int y0 = position[1];
            int y1 = position[3];
            QuadHelper.loadQuad((SimpleBufferBuilder)bb, (float)x0, (float)x1, (float)y0, (float)y1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (int)context.colourScheme().foreground().packedint(alpha));
            QuadHelper.loadQuad((SimpleBufferBuilder)bb, (float)(x0 += inset), (float)(x1 -= inset), (float)(y0 += inset), (float)(y1 -= inset), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (int)context.colourScheme().background().packedint(RefRenderElement.getGlobalAlpha()));
            float width = 400 * context.scale();
            x1 = x0 + inset + (int)(progress[1] * width);
            QuadHelper.loadQuad((SimpleBufferBuilder)bb, (float)(x0 += (int)((float)inset + progress[0] * width)), (float)x1, (float)(y0 += inset), (float)(y1 -= inset), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (int)colour);
            bb.draw();
        };
    }

    protected void renderText(StartupProgressBar.TextGenerator textGenerator, CSB csb) {
        csb.ctx().elementShader().updateTextureUniform(this.fontTextureId);
        csb.ctx().elementShader().updateRenderTypeUniform(ElementShader.RenderType.FONT);
        csb.buffer().begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        textGenerator.accept(csb.buffer(), this.font, csb.ctx());
        csb.buffer().draw();
    }

    protected StartupProgressBar.TextGenerator text(int x, int y, String text, int colour) {
        return (bb, font, context) -> font.generateVerticesForTexts(x, y, bb, new SimpleFont.DisplayText[]{new SimpleFont.DisplayText(text, colour)});
    }

    public static interface ColorFunction {
        public int color(int var1);
    }

    public static interface ProgressDisplay {
        public float[] progress(int var1);
    }
}

