/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.BoundsResolver;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigurationException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.ElementSupplier;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper.ApngSTBHelper;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper.ApngTexture;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.CSB;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngException;
import java.io.FileNotFoundException;
import java.util.Set;
import net.minecraftforge.fml.earlydisplay.ElementShader;
import net.minecraftforge.fml.earlydisplay.QuadHelper;
import net.minecraftforge.fml.earlydisplay.SimpleBufferBuilder;
import org.jline.utils.Log;
import org.lwjgl.opengl.GL32C;

public class ApngTextureElement
implements ElementSupplier {
    public static final Set<String> SUPPORTED_EXTENSIONS = Set.of("apng");
    private final ApngTexture apngTexture;
    private final BoundsResolver boundsResolver;
    private long lastFrameTime;

    public ApngTextureElement(String texture, BoundsResolver boundsResolver) {
        this.boundsResolver = boundsResolver;
        try {
            this.apngTexture = ApngSTBHelper.resolveAndBindApngTexture(texture);
        }
        catch (PngException | FileNotFoundException e) {
            Log.error((Object[])new Object[]{"Failed to load texture: ", e.getMessage()});
            throw new ConfigurationException(e);
        }
        this.lastFrameTime = System.currentTimeMillis();
    }

    @Override
    public void render(CSB csb, int frame) {
        int[] bounds = this.boundsResolver.resolveBounds(this.apngTexture.getTotalWidth(), this.apngTexture.getTotalHeight(), csb.ctx().scaledWidth(), csb.ctx().scaledHeight());
        float[] uvs = this.getUV();
        csb.ctx().elementShader().updateTextureUniform(0);
        csb.ctx().elementShader().updateRenderTypeUniform(ElementShader.RenderType.TEXTURE);
        GL32C.glBindTexture((int)3553, (int)this.apngTexture.getCurrentTextureId());
        csb.buffer().begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        QuadHelper.loadQuad((SimpleBufferBuilder)csb.buffer(), (float)bounds[0], (float)bounds[2], (float)bounds[1], (float)bounds[3], (float)uvs[0], (float)uvs[1], (float)uvs[2], (float)uvs[3], (int)-1);
        csb.buffer().draw();
        GL32C.glBindTexture((int)3553, (int)0);
        this.nextFrame();
    }

    private void nextFrame() {
        if ((float)(System.currentTimeMillis() - this.lastFrameTime) > this.apngTexture.getCurrentDelay() * 1000.0f) {
            this.apngTexture.nextFrame();
            this.lastFrameTime = System.currentTimeMillis();
        }
    }

    private float[] getUV() {
        float[] uv = new float[4];
        int[] currentTextureSize = this.apngTexture.getCurrentTextureSize();
        uv[0] = (float)this.apngTexture.getCurrentTextureXOffset() / (float)currentTextureSize[0];
        uv[1] = (float)(this.apngTexture.getCurrentTextureXOffset() + this.apngTexture.getCurrentFrameWidth()) / (float)currentTextureSize[0];
        uv[2] = (float)this.apngTexture.getCurrentTextureYOffset() / (float)currentTextureSize[1];
        uv[3] = (float)(this.apngTexture.getCurrentTextureYOffset() + this.apngTexture.getCurrentFrameHeight()) / (float)currentTextureSize[1];
        return uv;
    }
}

