/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.SimpleCustomEarlyLoadingWindow;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.ObjectFieldCopier;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefDisplayWindow;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefImmediateWindowHandler;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class DummyTransformationService
implements ITransformationService {
    private static final Logger LOG = LogManager.getLogger();

    public DummyTransformationService() {
        LOG.debug("Injecting Simple Custom Early Loading");
        DummyTransformationService.injectAndReplaceEarlyWindow();
    }

    private static void injectAndReplaceEarlyWindow() {
        SimpleCustomEarlyLoadingWindow newProvider = new SimpleCustomEarlyLoadingWindow();
        if ("fmlearlywindow".equals(RefImmediateWindowHandler.getProvider().name()) && RefImmediateWindowHandler.getProvider().getClass().equals(DisplayWindow.class)) {
            DummyTransformationService.replaceImmediateWindowHandler(newProvider, (DisplayWindow)RefImmediateWindowHandler.getProvider());
            LOG.info("Injected Simple Custom Early Loading");
        } else {
            LOG.error("Something went really wrong!\nImmediate window provider mismatch!\nExpected: {}\nActual: {}\nThe Simple Custom Early loading can't be injected.\n", DisplayWindow.class, RefImmediateWindowHandler.getProvider().getClass());
        }
    }

    private static void replaceImmediateWindowHandler(SimpleCustomEarlyLoadingWindow newProvider, DisplayWindow oldProvider) {
        RefDisplayWindow displayWindow = new RefDisplayWindow(oldProvider);
        ScheduledFuture<?> initializationFuture = displayWindow.getInitializationFuture();
        try {
            initializationFuture.get();
        }
        catch (ExecutionException e) {
            LOG.atError().withThrowable((Throwable)e).log("Early loading initialization failed");
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        ObjectFieldCopier.copyAllFields(RefImmediateWindowHandler.getProvider(), (Object)newProvider, DisplayWindow.class);
        RefImmediateWindowHandler.setProvider(newProvider);
        FMLLoader.progressWindowTick = newProvider.reinitializeAfterStateCopy();
    }

    public String name() {
        return "SimpleCustomEarlyLoading_DummyTransformationService";
    }

    public void initialize(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    public @NonNull List<ITransformer> transformers() {
        return List.of();
    }
}

