/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.particle.AbstractTrailParticle;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Not_Spin_TrailParticle
extends AbstractTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/gathering_lightning.png");
    private boolean arrive = false;
    private final double xTarget;
    private final double yTarget;
    private final double zTarget;
    private final float reduction;
    private final float acceleration;
    private final double direction;

    protected Not_Spin_TrailParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float r, float g, float b, float gravity, float reduction, float acceleration, double direction, int life) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed, r, g, b);
        this.f_107230_ = 1.0f;
        this.f_107219_ = false;
        this.f_107226_ = gravity;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.xTarget = xSpeed;
        this.yTarget = ySpeed;
        this.zTarget = zSpeed;
        this.reduction = reduction;
        this.acceleration = acceleration;
        this.direction = direction;
        this.f_107225_ = life;
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    @Override
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        super.m_5744_(vertexConsumer, camera, partialTick);
    }

    public float getAlpha() {
        return Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        Vec3 travelVec = new Vec3(this.xTarget - this.f_107212_, this.yTarget - this.f_107213_, this.zTarget - this.f_107214_);
        if (!this.arrive) {
            if (travelVec.m_82553_() > 1.0) {
                travelVec = travelVec.m_82541_();
                this.f_107215_ = this.f_107215_ * (double)this.reduction + travelVec.f_82479_ * (double)this.acceleration + this.direction;
                this.f_107216_ = this.f_107216_ * (double)this.reduction + travelVec.f_82480_ * (double)this.acceleration + this.direction;
                this.f_107217_ = this.f_107217_ * (double)this.reduction + travelVec.f_82481_ * (double)this.acceleration + this.direction;
            } else {
                this.arrive = true;
            }
        } else {
            this.f_107224_ = Math.min(this.f_107224_ + 3, this.f_107225_);
            this.f_107216_ -= (double)this.f_107226_;
        }
        float fadeIn = Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        float fadeOut = Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.trailA = fadeIn * fadeOut;
    }

    @Override
    public float getTrailHeight() {
        return 0.4f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public static class NSTData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<NSTData> DESERIALIZER = new ParticleOptions.Deserializer<NSTData>(){

            public NSTData fromCommand(ParticleType<NSTData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = reader.readFloat();
                reader.expect(' ');
                float g = reader.readFloat();
                reader.expect(' ');
                float b = reader.readFloat();
                reader.expect(' ');
                float gravity = reader.readFloat();
                reader.expect(' ');
                float reduction = reader.readFloat();
                reader.expect(' ');
                float acceleration = reader.readFloat();
                reader.expect(' ');
                double direction = reader.readDouble();
                reader.expect(' ');
                int life = reader.readInt();
                return new NSTData(r, g, b, gravity, reduction, acceleration, direction, life);
            }

            public NSTData fromNetwork(ParticleType<NSTData> particleTypeIn, FriendlyByteBuf buffer) {
                return new NSTData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readDouble(), buffer.readInt());
            }
        };
        private final float r;
        private final float g;
        private final float b;
        private final float gravity;
        private final float reduction;
        private final float acceleration;
        private final double direction;
        private final int life;

        public NSTData(float r, float g, float b, float gravity, float reduction, float acceleration, double direction, int life) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.gravity = gravity;
            this.reduction = reduction;
            this.acceleration = acceleration;
            this.direction = direction;
            this.life = life;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.gravity);
            buffer.writeFloat(this.reduction);
            buffer.writeFloat(this.acceleration);
            buffer.writeDouble(this.direction);
            buffer.writeInt(this.life);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.gravity), Float.valueOf(this.reduction), Float.valueOf(this.acceleration), this.direction, this.life);
        }

        public ParticleType<NSTData> m_6012_() {
            return (ParticleType)ModParticle.NOT_SPIN_PARTICLE.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getGravity() {
            return this.gravity;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getReduction() {
            return this.reduction;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getAcceleration() {
            return this.acceleration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public double getDirection() {
            return this.direction;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getLife() {
            return this.life;
        }

        public static Codec<NSTData> CODEC(ParticleType<NSTData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(NSTData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(NSTData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(NSTData::getB), (App)Codec.FLOAT.fieldOf("gravity").forGetter(NSTData::getGravity), (App)Codec.FLOAT.fieldOf("reduction").forGetter(NSTData::getReduction), (App)Codec.FLOAT.fieldOf("acceleration").forGetter(NSTData::getAcceleration), (App)Codec.DOUBLE.fieldOf("direction").forGetter(NSTData::getDirection), (App)Codec.INT.fieldOf("life").forGetter(NSTData::getLife)).apply((Applicative)codecBuilder, NSTData::new));
        }
    }

    public static class Factory
    implements ParticleProvider<NSTData> {
        public Particle createParticle(NSTData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Not_Spin_TrailParticle particle = new Not_Spin_TrailParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, data.getR(), data.getG(), data.getB(), data.getGravity(), data.getReduction(), data.getAcceleration(), data.getDirection(), data.getLife());
            return particle;
        }
    }
}

