/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.mixin;

import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Events;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PersistentEntitySectionManager.class})
public abstract class MixinPersistentEntitySectionManager<Type extends EntityAccess> {
    private final Long2ObjectMap<Pair<Entity, Boolean>> majruszlibrary$pendingEvents = new Long2ObjectOpenHashMap();

    @Inject(at={@At(value="RETURN")}, method={"addEntity (Lnet/minecraft/world/level/entity/EntityAccess;Z)Z"})
    private void addEntity(Type entityAccess, boolean isLoadedFromDisk, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)callback.getReturnValue()).booleanValue() && entityAccess instanceof Entity) {
            Entity entity = (Entity)entityAccess;
            this.majruszlibrary$pendingEvents.put((long)entity.m_19879_(), (Object)Pair.of((Object)entity, (Object)isLoadedFromDisk));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick ()V"})
    private void tick(CallbackInfo callback) {
        ArrayList ids = new ArrayList();
        this.majruszlibrary$pendingEvents.forEach((id, context) -> {
            if (Events.dispatch(new OnEntitySpawned((Entity)context.getFirst(), (Boolean)context.getSecond())).isSpawnCancelled()) {
                ((Entity)context.getFirst()).m_142687_(Entity.RemovalReason.DISCARDED);
            }
            ids.add(id);
        });
        ids.forEach(arg_0 -> this.majruszlibrary$pendingEvents.remove(arg_0));
    }
}

