/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.KiwiGO;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.network.SSnowLandEffectPacket;
import snownee.snow.util.CommonProxy;

public final class Hooks {
    private Hooks() {
    }

    public static boolean canGrassSurvive(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos blockPos2 = blockPos.m_7494_();
        BlockState blockState2 = level.m_8055_(blockPos2);
        if (blockState2.m_204336_(CoreModule.SNOWY_SETTING)) {
            Block block = blockState2.m_60734_();
            if (block instanceof SnowVariant) {
                SnowVariant snowVariant = (SnowVariant)block;
                return SnowCommonConfig.sustainGrassIfLayerMoreThanOne || snowVariant.layers(blockState2, (BlockGetter)level, blockPos2) <= 1;
            }
            return true;
        }
        int i = LightEngine.m_284282_((BlockGetter)level, (BlockState)blockState, (BlockPos)blockPos, (BlockState)blockState2, (BlockPos)blockPos2, (Direction)Direction.UP, (int)blockState2.m_60739_((BlockGetter)level, blockPos2));
        return i < level.m_7469_();
    }

    public static boolean placeFeature(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel worldgenlevel = ctx.m_159774_();
        BlockPos origin = ctx.m_159777_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BlockState blockstate;
                int k = origin.m_123341_() + i;
                int l = origin.m_123343_() + j;
                int i1 = worldgenlevel.m_6924_(Heightmap.Types.MOTION_BLOCKING, k, l);
                pos.m_122178_(k, i1, l);
                belowPos.m_122190_((Vec3i)pos).m_122173_(Direction.DOWN);
                Holder biomeHolder = worldgenlevel.m_204166_((BlockPos)pos);
                Biome biome = (Biome)biomeHolder.m_203334_();
                if (biome.m_47480_((LevelReader)worldgenlevel, (BlockPos)belowPos, false)) {
                    worldgenlevel.m_7731_((BlockPos)belowPos, Blocks.f_50126_.m_49966_(), 2);
                }
                if (biome.m_47519_((LevelReader)worldgenlevel, (BlockPos)pos)) {
                    worldgenlevel.m_7731_((BlockPos)pos, Blocks.f_50125_.m_49966_(), 2);
                    blockstate = worldgenlevel.m_8055_((BlockPos)belowPos);
                    if (!blockstate.m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                    worldgenlevel.m_7731_((BlockPos)belowPos, (BlockState)blockstate.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                    continue;
                }
                if (!SnowCommonConfig.replaceWorldFeature || !SnowCommonConfig.placeSnowOnBlockNaturally || !SnowCommonConfig.canPlaceSnowInBlock() || biome.m_198906_((BlockPos)pos)) continue;
                if (!Blocks.f_50125_.m_49966_().m_60710_((LevelReader)worldgenlevel, (BlockPos)pos)) {
                    pos.m_122173_(Direction.DOWN);
                    belowPos.m_122173_(Direction.DOWN);
                }
                blockstate = worldgenlevel.m_8055_((BlockPos)pos);
                if (SnowCommonConfig.skipSnowLoggingMushroom && blockstate.m_60734_().getClass() == MushroomBlock.class || !Hooks.canContainState(blockstate)) continue;
                if (!blockstate.m_60710_((LevelReader)worldgenlevel, (BlockPos)pos)) {
                    blockstate = Blocks.f_50016_.m_49966_();
                }
                if (!Hooks.convert((LevelAccessor)worldgenlevel, (BlockPos)pos, blockstate, 1, 2, true) || !(blockstate = worldgenlevel.m_8055_((BlockPos)belowPos)).m_61138_((Property)SnowyDirtBlock.f_56637_)) continue;
                worldgenlevel.m_7731_((BlockPos)belowPos, (BlockState)blockstate.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }

    public static boolean canSnowSurvive(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos = pos.m_7495_());
        if (blockstate.m_204336_(BlockTags.f_215833_)) {
            return false;
        }
        if (blockstate.m_204336_(BlockTags.f_215834_)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)blockstate.m_60812_(level, pos), (Direction)Direction.UP);
    }

    public static boolean canContainState(BlockState state) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.m_155947_() || !state.m_60819_().m_76178_()) {
            return false;
        }
        Block block = state.m_60734_();
        if (state.m_204336_(CoreModule.NOT_CONTAINABLES)) {
            return false;
        }
        if (state.m_204336_(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            return true;
        }
        if (block instanceof FenceBlock) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE.defaultBlockState());
        }
        if (block instanceof FenceGateBlock) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE_GATE.defaultBlockState());
        }
        if (block instanceof WallBlock) {
            return Hooks.hasAllProperties(state, CoreModule.WALL.defaultBlockState());
        }
        if (block instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
            return true;
        }
        if (block instanceof StairBlock && state.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM) {
            return Hooks.hasAllProperties(state, CoreModule.STAIRS.defaultBlockState());
        }
        return false;
    }

    public static boolean convert(LevelAccessor level, BlockPos pos, BlockState state, int layers, int flags, boolean canConvert) {
        if (state.m_60795_()) {
            Hooks.placeNormalSnow(level, pos, layers, flags);
            return true;
        }
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.m_155947_()) {
            return false;
        }
        if (!canConvert) {
            return false;
        }
        Block block = state.m_60734_();
        if (state.m_204336_(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            level.m_7731_(pos, (BlockState)CoreModule.TILE_BLOCK.defaultBlockState().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers)), flags);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SnowBlockEntity) {
                SnowBlockEntity snowBlockEntity = (SnowBlockEntity)blockEntity;
                snowBlockEntity.setContainedState(state);
            }
            return true;
        }
        BlockPos posDown = pos.m_7495_();
        BlockState stateDown = level.m_8055_(posDown);
        if (block instanceof StairBlock && !CoreModule.STAIRS.is(state)) {
            newState = CoreModule.STAIRS.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            level.m_7731_(pos, newState, flags);
        } else if (block instanceof SlabBlock && !CoreModule.SLAB.is(state) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
            level.m_7731_(pos, CoreModule.SLAB.defaultBlockState(), flags);
        } else if (block instanceof FenceBlock && block.getClass() != SnowFenceBlock.class) {
            KiwiGO<Block> newBlock = state.m_204336_(BlockTags.f_13098_) || state.m_60827_() == SoundType.f_56736_ ? CoreModule.FENCE : CoreModule.FENCE2;
            BlockState newState = newBlock.defaultBlockState();
            newState = (BlockState)Hooks.copyProperties(state, newState).m_61124_((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            newState = newState.m_60728_(Direction.DOWN, stateDown, level, pos, posDown);
            level.m_7731_(pos, newState, flags);
        } else if (block instanceof FenceGateBlock && !CoreModule.FENCE_GATE.is(state)) {
            newState = CoreModule.FENCE_GATE.defaultBlockState();
            newState = (BlockState)Hooks.copyProperties(state, newState).m_61124_((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            newState = newState.m_60728_(Direction.DOWN, stateDown, level, pos, posDown);
            level.m_7731_(pos, newState, flags);
        } else if (block instanceof WallBlock && !CoreModule.WALL.is(state)) {
            newState = CoreModule.WALL.defaultBlockState();
            newState = (BlockState)Hooks.copyProperties(state, newState).m_61124_((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            newState = newState.m_60728_(Direction.DOWN, stateDown, level, pos, posDown);
            level.m_7731_(pos, newState, flags);
        } else {
            return false;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof SnowBlockEntity) {
            ((SnowBlockEntity)tile).setContainedState(state);
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean hasAllProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : newState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (property == SnowVariant.OPTIONAL_LAYERS || oldState.m_61138_(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            if (!newState.m_61138_(property)) continue;
            newState = (BlockState)newState.m_61124_(property, (Comparable)property.m_61709_().cast(entry.getValue()));
        }
        return newState;
    }

    public static boolean placeLayersOn(Level level, BlockPos pos, int layers, boolean fallingEffect, BlockPlaceContext useContext, boolean playSound, boolean canConvert) {
        layers = Mth.m_14045_((int)layers, (int)1, (int)8);
        BlockState state = level.m_8055_(pos);
        int originLayers = 0;
        if (state.m_61138_((Property)SnowLayerBlock.f_56581_)) {
            originLayers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Mth.m_14045_((int)(originLayers + layers), (int)1, (int)8))));
        } else if (state.m_61138_((Property)SnowVariant.OPTIONAL_LAYERS)) {
            originLayers = (Integer)state.m_61143_((Property)SnowVariant.OPTIONAL_LAYERS);
            if (originLayers == 0 && !Hooks.canSnowSurvive(state, (BlockGetter)level, pos)) {
                return false;
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(Mth.m_14045_((int)(originLayers + layers), (int)1, (int)8))));
        } else if (canConvert && Hooks.canContainState(state) && state.m_60710_((LevelReader)level, pos)) {
            Hooks.convert((LevelAccessor)level, pos, state, Mth.m_14045_((int)layers, (int)1, (int)8), 3, canConvert);
        } else if (Hooks.canSnowSurvive(state, (BlockGetter)level, pos) && state.m_60629_(useContext)) {
            Hooks.placeNormalSnow((LevelAccessor)level, pos, layers, 3);
        } else {
            return false;
        }
        BlockState newState = level.m_8055_(pos);
        Block.m_49897_((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos);
        if (fallingEffect) {
            SSnowLandEffectPacket.send(level, pos, originLayers, layers);
        } else if (playSound) {
            SoundType soundtype = Blocks.f_50125_.m_49962_(Blocks.f_50125_.m_49966_());
            level.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.m_7494_();
            newState = level.m_8055_(pos);
            useContext = BlockPlaceContext.m_43644_((BlockPlaceContext)useContext, (BlockPos)pos, (Direction)Direction.UP);
            if (Hooks.canSnowSurvive(Blocks.f_50125_.m_49966_(), (BlockGetter)level, pos) && newState.m_60629_(useContext)) {
                Hooks.placeLayersOn(level, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound, canConvert);
            }
        }
        return true;
    }

    public static void placeNormalSnow(LevelAccessor level, BlockPos pos, int layers, int flags) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        Block block = SnowCommonConfig.fancySnowOnUpperSlab && stateBelow.m_60734_() instanceof SlabBlock ? (Block)CoreModule.TILE_BLOCK.get() : Blocks.f_50125_;
        stateBelow = (BlockState)block.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Mth.m_14045_((int)layers, (int)1, (int)8)));
        level.m_7731_(pos, stateBelow, flags);
        if (CoreModule.TILE_BLOCK.is((Object)block)) {
            Hooks.setPlacedBy(level, pos, stateBelow);
        }
    }

    public static void setPlacedBy(LevelAccessor level, BlockPos pos, BlockState state) {
        SnowBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof SnowBlockEntity && (blockEntity = (SnowBlockEntity)blockEntity2).getContainedState().m_60795_()) {
            blockEntity.options.update(true);
        }
    }

    public static boolean canFallThrough(BlockState state, Level level, BlockPos pos) {
        SnowVariant snow;
        Block block = state.m_60734_();
        if (block instanceof SnowVariant && (snow = (SnowVariant)block).maxLayers(state, level, pos) == 8 && snow.layers(state, (BlockGetter)level, pos) < 8) {
            return true;
        }
        return FallingBlock.m_53241_((BlockState)state) && state.m_60812_((BlockGetter)level, pos).m_83281_();
    }

    public static void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Hooks.randomTick(state, level, pos, random, 0.125f);
    }

    public static void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, float chance) {
        boolean melt;
        if (CommonProxy.terraforged) {
            return;
        }
        if (chance != 1.0f && random.m_188501_() > chance) {
            return;
        }
        Holder biome = level.m_204166_(pos);
        SnowVariant snow = (SnowVariant)state.m_60734_();
        int layers = snow.layers(state, (BlockGetter)level, pos);
        boolean meltByTemperature = false;
        boolean meltByBrightness = false;
        if (!SnowCommonConfig.snowNeverMelt) {
            if (layers == 8) {
                SnowVariant s;
                BlockPos above = pos.m_7494_();
                BlockState upState = level.m_8055_(above);
                Block block = upState.m_60734_();
                if (block instanceof SnowVariant && (s = (SnowVariant)block).layers(upState, (BlockGetter)level, above) > 0) {
                    return;
                }
                meltByBrightness = level.m_45517_(LightLayer.BLOCK, above) >= SnowCommonConfig.snowPersistMaxLightLevel;
            } else {
                meltByBrightness = level.m_45517_(LightLayer.BLOCK, pos) > SnowCommonConfig.snowPersistMaxLightLevel;
            }
            meltByTemperature = CommonProxy.shouldMelt((Level)level, pos, (Holder<Biome>)biome, layers);
        }
        boolean bl = melt = meltByTemperature || meltByBrightness;
        if (!melt && SnowCommonConfig.accumulationWinterOnly && !CommonProxy.isWinter((Level)level, pos, (Holder<Biome>)biome)) {
            return;
        }
        boolean accumulate = false;
        if (layers < SnowCommonConfig.snowAccumulationMaxLayers && !meltByBrightness && level.m_46471_() && CommonProxy.coldEnoughToSnow((Level)level, pos, (Holder<Biome>)biome)) {
            accumulate = CommonProxy.snowAccumulationNow((Level)level);
        }
        if (accumulate) {
            if (!level.m_8055_(pos.m_7495_()).m_204336_(CoreModule.CANNOT_ACCUMULATE_ON)) {
                Hooks.accumulate(level, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.m_8055_(p.m_7495_()).m_60734_() instanceof SnowLayerBlock)) && w.m_45517_(LightLayer.BLOCK, p) <= SnowCommonConfig.snowSpawnMaxLightLevel, true);
            }
        } else if (melt) {
            Hooks.accumulate(level, pos, state, (w, p) -> !(w.m_8055_(p.m_7494_()).m_60734_() instanceof SnowLayerBlock), false);
        }
    }

    private static void accumulate(ServerLevel level, BlockPos pos, BlockState centerState, BiPredicate<LevelAccessor, BlockPos> filter, boolean accumulate) {
        SnowVariant centerSnowVariant = (SnowVariant)centerState.m_60734_();
        int i = centerSnowVariant.layers(centerState, (BlockGetter)level, pos);
        BlockPos.MutableBlockPos pos2 = pos.m_122032_();
        for (int j = 0; j < 8; ++j) {
            int l;
            SnowVariant snowVariant;
            int k = j / 2;
            Direction direction = Direction.m_122407_((int)k);
            pos2.m_122159_((Vec3i)pos, direction);
            if (j % 2 == 1) {
                pos2.m_122173_(direction);
            }
            if (!level.m_46749_((BlockPos)pos2) || !filter.test((LevelAccessor)level, (BlockPos)pos2)) continue;
            BlockState state = level.m_8055_((BlockPos)pos2);
            BlockPos height = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos2);
            if (height.m_123342_() != pos2.m_123342_() && (height.m_123342_() != pos2.m_123342_() + 1 || !(state.m_60734_() instanceof SnowVariant)) || !Hooks.canSnowSurvive(state, (BlockGetter)level, (BlockPos)pos2)) continue;
            Block block = state.m_60734_();
            if (block instanceof SnowVariant) {
                snowVariant = (SnowVariant)block;
                l = snowVariant.layers(state, (BlockGetter)level, (BlockPos)pos2);
                if (accumulate) {
                    if (l >= snowVariant.maxLayers(state, (Level)level, (BlockPos)pos2) || level.m_8055_((BlockPos)pos2.m_122173_(Direction.DOWN)).m_204336_(CoreModule.CANNOT_ACCUMULATE_ON)) continue;
                    pos2.m_122173_(Direction.UP);
                }
            } else {
                l = 0;
            }
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                Hooks.placeLayersOn((Level)level, (BlockPos)pos2, 1, false, (BlockPlaceContext)new DirectionalPlaceContext((Level)level, (BlockPos)pos2, Direction.UP, ItemStack.f_41583_, Direction.DOWN), false, SnowCommonConfig.placeSnowOnBlockNaturally);
            } else {
                snowVariant = (SnowVariant)state.m_60734_();
                level.m_46597_((BlockPos)pos2, snowVariant.decreaseLayer(state, (Level)level, (BlockPos)pos2, false));
            }
            return;
        }
        if (accumulate) {
            Hooks.placeLayersOn((Level)level, pos, 1, false, (BlockPlaceContext)new DirectionalPlaceContext((Level)level, pos, Direction.UP, ItemStack.f_41583_, Direction.DOWN), false, SnowCommonConfig.placeSnowOnBlockNaturally);
        } else {
            level.m_46597_(pos, centerSnowVariant.decreaseLayer(centerState, (Level)level, pos, false));
        }
    }

    public static boolean isSnowySetting(BlockState state) {
        if (state.m_204336_(CoreModule.SNOWY_SETTING)) {
            return !state.m_61138_((Property)SnowVariant.OPTIONAL_LAYERS) || (Integer)state.m_61143_((Property)SnowVariant.OPTIONAL_LAYERS) != 0;
        }
        return false;
    }

    public static boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (!context.m_43722_().m_150930_(Items.f_41979_) || !context.m_7058_()) {
            return false;
        }
        int i = (Integer)state.m_61143_((Property)SnowVariant.OPTIONAL_LAYERS);
        if (i == 8) {
            return false;
        }
        return i > 0 || Hooks.canSnowSurvive(state, (BlockGetter)context.m_43725_(), context.m_8083_());
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateBelow;
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_61138_((Property)SnowLayerBlock.f_56581_)) {
            int i = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            return (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        if (state.m_61138_((Property)SnowVariant.OPTIONAL_LAYERS)) {
            int i = (Integer)state.m_61143_((Property)SnowVariant.OPTIONAL_LAYERS);
            return (BlockState)state.m_61124_((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        ItemStack stack = context.m_43722_();
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null && "snowrealmagic:snow".equals(tag.m_128461_("id"))) {
            return CoreModule.TILE_BLOCK.defaultBlockState();
        }
        if (SnowCommonConfig.fancySnowOnUpperSlab && (stateBelow = context.m_43725_().m_8055_(context.m_8083_().m_7495_())).m_60734_() instanceof SlabBlock) {
            return CoreModule.TILE_BLOCK.defaultBlockState();
        }
        return Blocks.f_50125_.m_49966_();
    }

    public static boolean isFallable(BlockState blockState) {
        return SnowCommonConfig.snowGravity && (blockState.m_60713_(Blocks.f_50125_) || CoreModule.TILE_BLOCK.is(blockState));
    }
}

