/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.structure.pool_elements;

import com.google.common.collect.Lists;
import com.legacy.rediscovered.registry.RediscoveredPoolElementTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import org.joml.SimplexNoise;

public class BrickPyramidIslandPoolElement
extends StructurePoolElement {
    public static final Codec<BrickPyramidIslandPoolElement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BrickPyramidIslandPoolElement.m_210538_()).apply((Applicative)instance, BrickPyramidIslandPoolElement::new));
    private final CompoundTag defaultJigsawNBT = this.fillDefaultJigsawNBT();

    public BrickPyramidIslandPoolElement(StructureTemplatePool.Projection projection) {
        super(projection);
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("pool", "minecraft:empty");
        tag.m_128359_("name", "minecraft:island_top");
        tag.m_128359_("target", "minecraft:pyramid_bottom");
        tag.m_128359_("final_state", "minecraft:air");
        tag.m_128359_("joint", JigsawBlockEntity.JointType.ROLLABLE.m_7912_());
        return tag;
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        list.add(new StructureTemplate.StructureBlockInfo(pos.m_7918_(0, this.m_213577_(structureTemplateManager, rotation).m_123342_(), 0), (BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.UP, (Direction)Direction.SOUTH)), this.defaultJigsawNBT));
        return list;
    }

    public Vec3i m_213577_(StructureTemplateManager structureTemplateManager, Rotation rotation) {
        int xz = 166;
        int y = 66;
        return new Vec3i(xz, y, xz);
    }

    public BoundingBox m_214015_(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation) {
        Vec3i size = this.m_213577_(structureTemplateManager, rotation);
        int dx = size.m_123341_() / 2;
        int dy = size.m_123342_() / 2;
        int dz = size.m_123343_() / 2;
        return BoundingBox.m_162375_((Vec3i)pos.m_7918_(-dx, -dy, -dz), (Vec3i)pos.m_7918_(dx, dy, dz));
    }

    public boolean m_213695_(StructureTemplateManager structureTemplateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, BlockPos pos, BlockPos structureOrigin, Rotation rotation, BoundingBox chunkBounds, RandomSource rand, boolean pKeepJigsaws) {
        BlockState baseMaterial = Blocks.f_50069_.m_49966_();
        BlockState topMaterial = Blocks.f_50440_.m_49966_();
        BlockState soilMaterial = Blocks.f_50493_.m_49966_();
        float horizontalNoiseScale = 4.0f;
        float verticalNoiseScale = 6.0f;
        int deltaDist = 7;
        float dicingAmount = 0.3f;
        BoundingBox bb = this.m_214015_(structureTemplateManager, pos, rotation);
        int maxDist = bb.m_71056_() / 2 - deltaDist;
        Vec3 originVec = structureOrigin.m_252807_();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = chunkBounds.m_162395_(); x <= chunkBounds.m_162399_(); ++x) {
            for (int z = chunkBounds.m_162398_(); z <= chunkBounds.m_162401_(); ++z) {
                float heightScale = 0.03f;
                int maxY = bb.m_162400_() + (int)((SimplexNoise.noise((float)((float)x * heightScale), (float)((float)z * heightScale)) + 1.0f) * 2.0f);
                for (int y = bb.m_162396_(); y <= maxY; ++y) {
                    BlockPos placePos = new BlockPos(x, y, z);
                    Vec3 vec = placePos.m_252807_();
                    int dicing = 9;
                    Vec3 dicedVec8 = new BlockPos(x / dicing * dicing, y / dicing * dicing, z / dicing * dicing).m_252807_();
                    float dist = (float)vec.m_82554_(originVec);
                    if (dist > (float)(maxDist + deltaDist)) continue;
                    Vec3[] vecs = new Vec3[]{vec, dicedVec8};
                    float[] noises = new float[vecs.length];
                    for (int i = 0; i < vecs.length; ++i) {
                        Vec3 v = vecs[i];
                        Vec3 angle = originVec.m_82546_(v).m_82541_().m_82549_(originVec);
                        noises[i] = SimplexNoise.noise((float)((float)angle.m_7096_() * horizontalNoiseScale), (float)((float)angle.m_7098_() * verticalNoiseScale), (float)((float)angle.m_7094_() * horizontalNoiseScale));
                    }
                    float n = noises[0] * (1.0f - dicingAmount) + noises[1] * dicingAmount;
                    float yScaling = (float)(y - bb.m_162396_()) / (float)bb.m_71057_();
                    float scale = (double)yScaling < 0.8335 ? 1.0f - (float)Math.pow(1.0f - yScaling, 5.0) : (float)Math.sin((double)yScaling * 2.0);
                    float threshold = ((float)maxDist + (float)deltaDist * n) * scale;
                    if (!(dist < threshold)) continue;
                    positions.add(placePos);
                }
            }
        }
        if (positions.isEmpty()) {
            return false;
        }
        ChunkAccess chunk = level.m_46865_(new BlockPos(chunkBounds.m_162395_(), chunkBounds.m_162396_(), chunkBounds.m_162398_()));
        Heightmap surfaceHM = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        Heightmap oceanHM = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        for (BlockPos placePos : positions) {
            BlockState state = baseMaterial;
            if (!positions.contains(placePos.m_6630_(1))) {
                state = topMaterial;
            } else if (!positions.contains(placePos.m_6630_(2))) {
                state = soilMaterial;
            } else if (!positions.contains(placePos.m_6630_(3)) && rand.m_188499_()) {
                state = soilMaterial;
            }
            level.m_7731_(placePos, state, 2);
            BlockPos hmPos = new BlockPos(SectionPos.m_123207_((int)placePos.m_123341_()), placePos.m_123342_() + 1, SectionPos.m_123207_((int)placePos.m_123343_()));
            surfaceHM.m_64249_(hmPos.m_123341_(), hmPos.m_123342_(), hmPos.m_123343_(), state);
            oceanHM.m_64249_(hmPos.m_123341_(), hmPos.m_123342_(), hmPos.m_123343_(), state);
        }
        return true;
    }

    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)RediscoveredPoolElementTypes.BRICK_PYRAMID_ISLAND.get();
    }

    public String toString() {
        return String.format("%s[projection=%s]", RediscoveredPoolElementTypes.BRICK_PYRAMID_ISLAND.getName(), this.m_210539_().m_7912_());
    }
}

