/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.structure;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.RediscoveredUtil;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.BeastBoyEntity;
import com.legacy.rediscovered.entity.BlackSteveEntity;
import com.legacy.rediscovered.entity.RanaEntity;
import com.legacy.rediscovered.entity.SteveEntity;
import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredJigsawTypes;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class PigmanVillageStructure {

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(context, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox bounds) {
            if ("pigman".equals(key)) {
                StructureStart start = level.m_6018_().m_215010_().m_220494_(pos, (Structure)RediscoveredStructures.PIGMAN_VILLAGE.getStructure().get((CommonLevelAccessor)level));
                BlockPos startPos = start.m_73603_() ? start.m_163625_().m_45615_() : pos;
                this.setAir((LevelAccessor)level, pos);
                PigmanEntity entity = (PigmanEntity)RediscoveredEntityTypes.PIGMAN.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                entity.villageOrigin = GlobalPos.m_122643_((ResourceKey)level.m_6018_().m_46472_(), (BlockPos)startPos.m_175288_(pos.m_123342_()));
                level.m_7967_((Entity)entity);
            } else if ("prisoner".equals(key)) {
                if (rand.m_188501_() < 0.9f && level.m_46791_() != Difficulty.PEACEFUL) {
                    this.setAir((LevelAccessor)level, pos);
                    Illusioner entity = (Illusioner)EntityType.f_20459_.m_20615_((Level)level.m_6018_());
                    entity.m_21530_();
                    entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                    entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, (SpawnGroupData)null, (CompoundTag)null);
                    entity.m_21051_(Attributes.f_22276_).m_22100_(50.0);
                    entity.m_21153_(entity.m_21233_());
                    level.m_7967_((Entity)entity);
                } else {
                    this.setAir((LevelAccessor)level, pos);
                    Villager entity = (Villager)EntityType.f_20492_.m_20615_((Level)level.m_6018_());
                    entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                    entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, (SpawnGroupData)null, (CompoundTag)null);
                    entity.m_34375_(entity.m_7141_().m_35567_(VillagerType.f_35821_).m_35565_(VillagerProfession.f_35596_));
                    level.m_7967_((Entity)entity);
                }
            } else if (key.startsWith("guard-")) {
                this.setAir((LevelAccessor)level, pos);
                GuardPigmanEntity entity = null;
                if (key.contains("melee")) {
                    entity = (GuardPigmanEntity)RediscoveredEntityTypes.MELEE_PIGMAN.m_20615_((Level)level.m_6018_());
                } else if (key.contains("ranged")) {
                    entity = (GuardPigmanEntity)RediscoveredEntityTypes.RANGED_PIGMAN.m_20615_((Level)level.m_6018_());
                }
                if (entity != null) {
                    entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                    entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                    level.m_7967_((Entity)entity);
                } else {
                    RediscoveredMod.LOGGER.error("Pigman Village guard was not assigned properly! Key: {}", (Object)key);
                }
            } else if ("steve".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                SteveEntity entity = (SteveEntity)RediscoveredEntityTypes.STEVE.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 1.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_7967_((Entity)entity);
            } else if ("rana".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                RanaEntity entity = (RanaEntity)RediscoveredEntityTypes.RANA.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 1.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_7967_((Entity)entity);
            } else if ("black_steve".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                BlackSteveEntity entity = (BlackSteveEntity)RediscoveredEntityTypes.BLACK_STEVE.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_7967_((Entity)entity);
            } else if ("beast_boy".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                BeastBoyEntity entity = (BeastBoyEntity)RediscoveredEntityTypes.BEAST_BOY.m_20615_((Level)level.m_6018_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                entity.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_7967_((Entity)entity);
            } else if (key.startsWith("chest-")) {
                this.setAir((LevelAccessor)level, pos);
                ResourceLocation lootTable = RediscoveredMod.locate("chests/pigman_village/" + key.substring(key.indexOf(45) + 1));
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)lootTable);
            } else {
                RediscoveredMod.LOGGER.error("Pigman Village data marker was not handled! Key: {}", (Object)key);
            }
        }

        public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
            if (originalState.m_60713_(Blocks.f_50036_)) {
                Optional<Holder<Block>> flower;
                float flowerChance;
                float f = rand.m_188501_();
                if (f < (flowerChance = 0.75f) && (flower = RediscoveredUtil.getRandomBlock(f <= flowerChance * 0.01f ? RediscoveredTags.Blocks.PIGMAN_VILLAGE_RARE_FLOWERS : RediscoveredTags.Blocks.PIGMAN_VILLAGE_FLOWERS, level, rand)).isPresent()) {
                    return ((Block)flower.get().get()).m_49966_();
                }
                return f < flowerChance + (1.0f - flowerChance) / 2.0f ? Blocks.f_50016_.m_49966_() : Blocks.f_50034_.m_49966_();
            }
            if (originalState.m_204336_(BlockTags.f_13039_) || originalState.m_60713_(Blocks.f_49990_)) {
                if (!(level instanceof ServerLevel)) {
                    level.m_46865_(pos).m_8113_(pos);
                }
                return originalState;
            }
            if (originalState.m_60713_(Blocks.f_152551_)) {
                return rand.m_188499_() ? Blocks.f_50069_.m_49966_() : Blocks.f_50493_.m_49966_();
            }
            return originalState;
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)RediscoveredStructures.PIGMAN_VILLAGE.getPieceType().get();
        }
    }

    public static class Capability
    implements JigsawCapability.IJigsawCapability {
        public static final Capability INSTANCE = new Capability();
        public static final Codec<Capability> CODEC = Codec.unit((Object)INSTANCE);

        public JigsawCapability.JigsawType<?> getType() {
            return RediscoveredJigsawTypes.PIGMAN_VILLAGE;
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

