/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.structure;

import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ObsidianWallPieces {
    public static void addPieces(StructureTemplateManager templateManager, BlockPos pos, Rotation rotation, StructurePiecesBuilder builder, WorldgenRandom rand) {
        int minBounds = 25;
        int maxBounds = 40;
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos.m_7918_(rand.m_216332_(minBounds, maxBounds), 10, rand.m_216332_(minBounds, maxBounds)));
        Vec2 direction = new Vec2((rand.m_188501_() - 0.5f) * 2.0f, (rand.m_188501_() - 0.5f) * 2.0f).m_165902_();
        float deltaAngle = (rand.m_188501_() - 0.5f) * 360.0f;
        builder.m_142679_((StructurePiece)new Piece(bounds, direction, deltaAngle));
    }

    public static class Piece
    extends StructurePiece {
        final Vec2 direction;
        final float deltaAngle;
        private static final String DIRECTION_KEY = "direction";
        private static final String DELTA_ANGLE_KEY = "delta_angle";

        protected Piece(BoundingBox boundingBox, Vec2 direction, float deltaAngle) {
            super((StructurePieceType)RediscoveredStructures.OBSIDIAN_WALL.getPieceType().get(), 0, boundingBox);
            this.direction = direction;
            this.deltaAngle = deltaAngle;
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super((StructurePieceType)RediscoveredStructures.OBSIDIAN_WALL.getPieceType().get(), tag);
            ListTag directionTag = tag.m_128437_(DIRECTION_KEY, 5);
            this.direction = directionTag.size() >= 2 ? new Vec2(directionTag.m_128775_(0), directionTag.m_128775_(1)) : new Vec2(1.0f, 0.0f);
            this.deltaAngle = tag.m_128457_(DELTA_ANGLE_KEY);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            ListTag directionTag = new ListTag();
            directionTag.add((Object)FloatTag.m_128566_((float)this.direction.f_82470_));
            directionTag.add((Object)FloatTag.m_128566_((float)this.direction.f_82471_));
            tag.m_128365_(DIRECTION_KEY, (Tag)directionTag);
            tag.m_128350_(DELTA_ANGLE_KEY, this.deltaAngle);
        }

        public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox chunkBounds, ChunkPos chunkPos, BlockPos pos) {
            ArrayList<Vec3> positions = new ArrayList<Vec3>();
            Vec3 center = this.f_73383_.m_162394_().m_175288_(this.f_73383_.m_162396_()).m_252807_();
            positions.add(center);
            Vec3 currentPos = center;
            Vec2 dir = this.direction;
            float s = 0.7f;
            while (this.f_73383_.m_71051_((Vec3i)BlockPos.m_274446_((Position)currentPos))) {
                currentPos = currentPos.m_82520_((double)dir.f_82470_, 0.0, (double)dir.f_82471_);
                positions.add(currentPos);
                dir = new Vec2(dir.f_82470_ + (rand.m_188501_() - 0.5f) * s, dir.f_82471_ + (rand.m_188501_() - 0.5f) * s).m_165902_();
            }
            currentPos = center;
            dir = this.direction;
            while (this.f_73383_.m_71051_((Vec3i)BlockPos.m_274446_((Position)currentPos))) {
                currentPos = currentPos.m_82492_((double)dir.f_82470_, 0.0, (double)dir.f_82471_);
                positions.add(currentPos);
                dir = new Vec2(dir.f_82470_ + (rand.m_188501_() - 0.5f) * s, dir.f_82471_ + (rand.m_188501_() - 0.5f) * s).m_165902_();
            }
            for (Vec3 p : positions) {
                BlockPos linePos = BlockPos.m_274446_((Position)p);
                if (!chunkBounds.m_71051_((Vec3i)linePos) || !this.f_73383_.m_71051_((Vec3i)linePos) || (linePos = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, linePos).m_7495_()).m_123342_() <= level.m_141937_()) continue;
                double distToCenter = (15.0 - center.m_82554_(p)) * 0.3;
                int height = rand.m_216339_(1, 4);
                int dy = 0;
                while ((double)dy < distToCenter + (double)height) {
                    level.m_7731_(linePos.m_6630_(dy), Piece.state(level, rand), 2);
                    ++dy;
                }
            }
        }

        private static BlockState state(WorldGenLevel level, RandomSource rand) {
            return rand.m_188501_() < 0.4f ? Blocks.f_50080_.m_49966_() : RediscoveredBlocks.ancient_crying_obsidian.m_49966_();
        }
    }
}

