/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.structure;

import com.legacy.rediscovered.registry.RediscoveredJigsawTypes;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class IndevHouseStructure {

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(context, tag);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox bounds) {
        }

        public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
            Optional cap = this.getCapability(Capability.class);
            if (cap.isEmpty()) {
                return originalState;
            }
            this.m_209918_();
            switch (((Capability)cap.get()).type) {
                case DEFAULT: {
                    originalState = this.toMossy(originalState, rand, 0.6);
                    originalState = this.toCracked(originalState, rand, 0.2);
                    originalState = this.gravelToStone(originalState, rand, 0.5);
                    break;
                }
                case MOSSY: {
                    originalState = this.toMossy(originalState, rand, 0.85);
                    originalState = this.toCracked(originalState, rand, 0.2);
                    originalState = this.gravelToStone(originalState, rand, 0.5);
                    break;
                }
                case CHERRY: {
                    originalState = this.toMossy(originalState, rand, 0.45);
                    originalState = this.toCracked(originalState, rand, 0.3);
                    originalState = this.gravelToStone(originalState, rand, 0.5);
                }
            }
            return originalState;
        }

        private BlockState toMossy(BlockState state, RandomSource rand, double chance) {
            if ((double)rand.m_188501_() > chance) {
                return state;
            }
            if (state.m_60713_(Blocks.f_50652_)) {
                return Blocks.f_50079_.m_49966_();
            }
            if (state.m_60713_(Blocks.f_50157_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50633_.m_49966_(), (BlockState)state);
            }
            if (state.m_60713_(Blocks.f_50409_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50647_.m_49966_(), (BlockState)state);
            }
            if (state.m_60713_(Blocks.f_50274_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50275_.m_49966_(), (BlockState)state);
            }
            if (state.m_60713_(Blocks.f_50222_)) {
                return Blocks.f_50223_.m_49966_();
            }
            if (state.m_60713_(Blocks.f_50194_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50631_.m_49966_(), (BlockState)state);
            }
            if (state.m_60713_(Blocks.f_50411_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50645_.m_49966_(), (BlockState)state);
            }
            if (state.m_60713_(Blocks.f_50609_)) {
                return IModifyState.mergeStates((BlockState)Blocks.f_50607_.m_49966_(), (BlockState)state);
            }
            return state;
        }

        private BlockState toCracked(BlockState state, RandomSource rand, double chance) {
            if ((double)rand.m_188501_() > chance) {
                return state;
            }
            if (state.m_60713_(Blocks.f_50222_)) {
                return Blocks.f_50224_.m_49966_();
            }
            return state;
        }

        private BlockState gravelToStone(BlockState state, RandomSource rand, double chance) {
            if ((double)rand.m_188501_() > chance) {
                return state;
            }
            if (state.m_60713_(Blocks.f_49994_)) {
                return Blocks.f_50652_.m_49966_();
            }
            return state;
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)RediscoveredStructures.INDEV_HOUSE.getPieceType().get();
        }
    }

    public static enum Type implements StringRepresentable
    {
        DEFAULT("default"),
        MOSSY("mossy"),
        CHERRY("cherry");

        public static final Codec<Type> CODEC;
        final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }

    public record Capability(Type type) implements JigsawCapability.IJigsawCapability
    {
        public static final Codec<Capability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("house_type").forGetter(Capability::type)).apply((Applicative)instance, Capability::new));

        public boolean canPlace(Structure.GenerationContext generationContext, BlockPos placementPos, ExtendedJigsawStructure.PlaceContext placeContext) {
            if (placeContext.projectStartToHeightmap().isEmpty()) {
                return true;
            }
            Heightmap.Types heightmap = (Heightmap.Types)placeContext.projectStartToHeightmap().get();
            LevelHeightAccessor heightAccess = generationContext.f_226629_();
            RandomState rand = generationContext.f_226624_();
            ChunkGenerator chunkGen = generationContext.f_226622_();
            int centerHeight = chunkGen.m_214096_(placementPos.m_123341_(), placementPos.m_123343_(), heightmap, heightAccess, rand);
            if (centerHeight < heightAccess.m_141937_() + 4) {
                return false;
            }
            int r = 5;
            int maxVariance = 5;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos p = placementPos.m_5484_(dir, r).m_5484_(dir.m_122427_(), r);
                int cornerHeight = chunkGen.m_214096_(p.m_123341_(), p.m_123343_(), heightmap, heightAccess, rand);
                if (Math.abs(centerHeight - cornerHeight) <= maxVariance) continue;
                return false;
            }
            return true;
        }

        public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, Structure.GenerationContext context) {
            IPieceBuilderModifier.getPieces((StructurePiecesBuilder)pieceBuilder).removeIf(piece -> piece.m_73547_().m_162396_() < context.f_226629_().m_141937_() + 4);
        }

        public JigsawCapability.JigsawType<?> getType() {
            return RediscoveredJigsawTypes.INDEV_HOUSE;
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

