/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.structure;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.RediscoveredUtil;
import com.legacy.rediscovered.data.RediscoveredLootProv;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.dragon.DragonPylonEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredJigsawTypes;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.phys.Vec3;

public class BrickPyramidStructure {

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(context, tag);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox bounds) {
            if ("mini_pylon".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                level.m_7731_(pos, RediscoveredBlocks.mini_dragon_pylon.m_49966_(), 3);
            } else if ("pylon".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                Vec3 p = Vec3.m_82512_((Vec3i)pos);
                RedDragonBossEntity redDragon = (RedDragonBossEntity)RediscoveredEntityTypes.RED_DRAGON_BOSS.m_20615_((Level)level.m_6018_());
                redDragon.m_146884_(p.m_82520_(0.0, 30.0, 0.0));
                redDragon.homePos = pos;
                redDragon.setPylonTime(20);
                level.m_7967_((Entity)redDragon);
                DragonPylonEntity pylon = new DragonPylonEntity((Level)level.m_6018_(), p.m_7096_(), p.m_7098_(), p.m_7094_());
                pylon.m_20242_(true);
                pylon.setAttachedDragonUUID(redDragon.m_20148_());
                level.m_7967_((Entity)pylon);
                redDragon.setPylonTime(60);
            } else if ("spawner".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                level.m_7731_(pos, Blocks.f_50085_.m_49966_(), 3);
                level.m_141902_(pos, BlockEntityType.f_58925_).ifPresent(spawner -> {
                    Optional<Holder<EntityType<?>>> randomEntity = RediscoveredUtil.getRandom(Registries.f_256939_, RediscoveredTags.Entities.BRICK_PYRAMID_SPAWNER, level.m_9598_(), rand);
                    spawner.m_252803_(randomEntity.isPresent() ? (EntityType)randomEntity.get().get() : EntityType.f_20501_, rand);
                });
            } else if ("decorated_pot".equals(key)) {
                this.setAir((LevelAccessor)level, pos);
                level.m_7731_(pos, Blocks.f_271197_.m_49966_(), 3);
                level.m_141902_(pos, BlockEntityType.f_271291_).ifPresent(pot -> {
                    int decorationCount = 4;
                    Item[] items = new Item[decorationCount];
                    Item brick = Items.f_42460_;
                    for (int i = 0; i < decorationCount; ++i) {
                        items[i] = (double)rand.m_188501_() < 0.33 ? RediscoveredUtil.getRandomItem(RediscoveredTags.Items.BRICK_PYRAMID_POTTERY_SHERDS, level, rand).map(Holder::get).orElse(brick) : brick;
                    }
                    DecoratedPotBlockEntity.Decorations decorations = new DecoratedPotBlockEntity.Decorations(items[0], items[1], items[2], items[3]);
                    ItemStack potItem = Items.f_271478_.m_7968_();
                    CompoundTag blockEntityTag = decorations.m_284135_(new CompoundTag());
                    BlockItem.m_186338_((ItemStack)potItem, (BlockEntityType)BlockEntityType.f_271291_, (CompoundTag)blockEntityTag);
                    pot.m_271870_(potItem);
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)rand, (BlockPos)pos, (ResourceLocation)RediscoveredLootProv.BRICK_PYRAMID_POT);
                });
            } else {
                RediscoveredMod.LOGGER.error("Brick Pyramid data marker was not handled! Key: {}", (Object)key);
            }
        }

        public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
            if (originalState.m_60713_(Blocks.f_220844_) && (double)rand.m_188501_() < 0.1) {
                return Blocks.f_220843_.m_49966_();
            }
            if (originalState.m_60713_(RediscoveredBlocks.brittle_mud_bricks) && (double)rand.m_188501_() < 0.1) {
                return RediscoveredBlocks.brittle_packed_mud.m_49966_();
            }
            if (originalState.m_60713_(Blocks.f_152483_)) {
                float f = rand.m_188501_();
                int count = (double)f < 0.4 ? 1 : ((double)f < 0.7 ? 2 : ((double)f < 0.85 ? 3 : 4));
                return (BlockState)(rand.m_188501_() < 0.3f ? Blocks.f_152524_ : Blocks.f_152523_).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(count));
            }
            if (originalState.m_60713_(Blocks.f_152484_)) {
                float f = rand.m_188501_();
                int count = (double)f < 0.4 ? 1 : ((double)f < 0.7 ? 2 : ((double)f < 0.85 ? 3 : 4));
                return (BlockState)((BlockState)(rand.m_188501_() < 0.3f ? Blocks.f_152524_ : Blocks.f_152523_).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(count))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf((double)rand.m_188501_() < 0.75));
            }
            return originalState;
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)RediscoveredStructures.BRICK_PYRAMID.getPieceType().get();
        }
    }

    public static class Capability
    implements JigsawCapability.IJigsawCapability {
        public static final Capability INSTANCE = new Capability();
        public static final Codec<Capability> CODEC = Codec.unit((Object)INSTANCE);

        public JigsawCapability.JigsawType<?> getType() {
            return RediscoveredJigsawTypes.BRICK_PYRAMID;
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

