/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.feature;

import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class SkylandsPoolFeature
extends Feature<Config> {
    public SkylandsPoolFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        int y;
        int z;
        int x;
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource rand = context.m_225041_();
        Config config = (Config)context.m_159778_();
        BlockState fluid = config.fluid;
        int radius = config.radius.m_214085_(rand);
        float fluidRadius = (float)radius - 1.5f;
        Optional<BlockState> edge = config.edge;
        Optional<BlockState> bottom = config.bottom;
        Optional<BlockState> wall = config.wall;
        TagKey<Block> replaceable = config.replaceable;
        Object[] hDirs = (Direction[])VoxelShapeUtil.HORIZONTAL_DIRS.toArray(Direction[]::new);
        float cutoutChance = config.cutoutChance;
        float dripleafChance = config.dripleafChance;
        BlockPos pos = origin;
        for (x = -radius; x <= radius; ++x) {
            for (z = -radius; z <= radius; ++z) {
                for (y = radius; y >= -radius; --y) {
                    boolean isEdge;
                    BlockState state;
                    int distSqr = x * x + y * y + z * z;
                    if (distSqr > radius * radius || !(state = level.m_8055_(pos = origin.m_7918_(x, y, z))).m_204336_(replaceable)) continue;
                    BlockState above = level.m_8055_(pos.m_7494_());
                    if (above.m_60795_()) {
                        BlockState placedState;
                        isEdge = (float)distSqr > fluidRadius * fluidRadius;
                        boolean nextToAir = false;
                        if (!isEdge && this.hasNeighbor(level, pos, (Direction[])hDirs, p -> level.m_8055_(p).m_60795_())) {
                            nextToAir = true;
                            isEdge = true;
                        }
                        boolean airBelow = level.m_8055_(pos.m_7495_()).m_60795_();
                        BlockState blockState = isEdge ? (!airBelow && nextToAir && rand.m_188501_() < cutoutChance ? Blocks.f_50016_.m_49966_() : (BlockState)edge.orElse(null)) : (placedState = airBelow ? null : fluid);
                        if (placedState == null) continue;
                        this.setBlock(level, pos, placedState);
                        continue;
                    }
                    if (bottom.isPresent() && above.m_60713_(fluid.m_60734_())) {
                        this.setBlock(level, pos, bottom.get());
                        continue;
                    }
                    if (!wall.isPresent() || !above.m_60713_(edge.get().m_60734_()) || !(isEdge = this.hasNeighbor(level, pos, (Direction[])hDirs, p -> level.m_8055_(p).m_60713_(fluid.m_60734_()) || level.m_8055_(p.m_7494_()).m_60795_()))) continue;
                    this.setBlock(level, pos, wall.get());
                }
            }
        }
        if (dripleafChance < 1.0f) {
            for (x = -radius; x <= radius; ++x) {
                for (z = -radius; z <= radius; ++z) {
                    for (y = radius; y >= -radius; --y) {
                        pos = origin.m_7918_(x, y, z);
                        if (!(rand.m_188501_() < 0.05f) || !level.m_8055_(pos).m_247087_() || !level.m_8055_(pos.m_7494_()).m_247087_() || !level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144278_)) continue;
                        BlockState dripleaf = (BlockState)Blocks.f_152547_.m_49966_().m_61124_((Property)SmallDripleafBlock.f_154577_, (Comparable)((Direction)Util.m_214670_((Object[])hDirs, (RandomSource)rand)));
                        level.m_7731_(pos, (BlockState)dripleaf.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(this.inOrNextToWater(level, pos, (Direction[])hDirs))), 16);
                        BlockPos abovePos = pos.m_7494_();
                        level.m_7731_(abovePos, (BlockState)((BlockState)dripleaf.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(this.inOrNextToWater(level, abovePos, (Direction[])hDirs)))).m_61124_((Property)SmallDripleafBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 16);
                    }
                }
            }
        }
        return true;
    }

    private boolean hasNeighbor(WorldGenLevel level, BlockPos pos, Direction[] offsets, Predicate<BlockPos> test) {
        for (Direction dir : offsets) {
            if (!test.test(pos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }

    private boolean inOrNextToWater(WorldGenLevel level, BlockPos pos, Direction[] offsets) {
        return level.m_8055_(pos).m_60713_(Blocks.f_49990_) || this.hasNeighbor(level, pos, offsets, p -> level.m_8055_(p).m_60713_(Blocks.f_49990_));
    }

    private void setBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (level.m_7731_(pos, state, 3) && !state.m_60819_().m_76178_()) {
            level.m_46865_(pos).m_8113_(pos);
        }
    }

    public record Config(BlockState fluid, IntProvider radius, Optional<BlockState> edge, float cutoutChance, Optional<BlockState> wall, Optional<BlockState> bottom, float dripleafChance, TagKey<Block> replaceable) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("fluid").forGetter(Config::fluid), (App)IntProvider.f_146532_.fieldOf("radius").forGetter(Config::radius), (App)BlockState.f_61039_.optionalFieldOf("edge").forGetter(Config::edge), (App)ExtraCodecs.f_184349_.fieldOf("cutout_chance").forGetter(Config::cutoutChance), (App)BlockState.f_61039_.optionalFieldOf("wall").forGetter(Config::wall), (App)BlockState.f_61039_.optionalFieldOf("bottom").forGetter(Config::bottom), (App)ExtraCodecs.f_184349_.fieldOf("dripleaf_chance").forGetter(Config::dripleafChance), (App)TagKey.m_203877_((ResourceKey)Registries.f_256747_).fieldOf("replaceable").forGetter(Config::replaceable)).apply((Applicative)instance, Config::new));
    }
}

