/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.feature;

import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.world.feature.AbstractSkyTreeFeature;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AncientCherryTreeFeature
extends AbstractSkyTreeFeature {
    public AncientCherryTreeFeature(AbstractSkyTreeFeature.TreeProperties properties) {
        super(properties);
    }

    @Override
    public boolean place(WorldGenLevel level, RandomSource rand, BlockPos pos, int height, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int min = 12;
        int max = 15;
        height = min + rand.m_188503_(max - min + 1);
        if (!this.isAreaOk(level, pos, height, 1, height - 2, 5)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, level, pos.m_7918_(0, y, 0), Blocks.f_271170_.m_49966_());
        }
        this.placeTopLeaves(level, rand, pos.m_6630_(height - 2), changedLogs, changedLeaves);
        for (Direction dir : VoxelShapeUtil.HORIZONTAL_DIRS) {
            if (!(rand.m_188501_() < 0.75f)) continue;
            this.placeBranch(level, rand, pos.m_6630_(Math.max(height - (rand.m_188503_(5) + 7), 3)), pos.m_123342_() + height - 4, dir, changedLogs, changedLeaves);
        }
        return true;
    }

    private void placeTopLeaves(WorldGenLevel level, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int z;
        int x;
        BlockState leaves = RediscoveredBlocks.ancient_cherry_leaves.m_49966_();
        this.setBlockIfOk(changedLogs, level, pos.m_7494_(), Blocks.f_271170_.m_49966_());
        int r = 3;
        for (x = -r; x <= r; ++x) {
            for (z = -r; z <= r; ++z) {
                if (Math.abs(x) + Math.abs(z) >= r + 2 || !(rand.m_188501_() < 0.8f)) continue;
                this.setBlockIfOk(changedLeaves, level, pos.m_7918_(x, -1, z), leaves);
            }
        }
        r = 4;
        for (x = -r; x <= r; ++x) {
            for (z = -r; z <= r; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    int dist = Math.abs(x) + Math.abs(z);
                    if (dist >= r + 2 && (dist >= r + 3 || !(rand.m_188501_() < 0.4f)) || Math.max(Math.abs(x), Math.abs(z)) == r && !((double)rand.m_188501_() < 0.75)) continue;
                    this.setBlockIfOk(changedLeaves, level, pos.m_7918_(x, y, z), leaves);
                }
            }
        }
        r = 3;
        for (x = -r; x <= r; ++x) {
            for (z = -r; z <= r; ++z) {
                if (Math.abs(x) + Math.abs(z) >= r + 2) continue;
                this.setBlockIfOk(changedLeaves, level, pos.m_7918_(x, 2, z), leaves);
            }
        }
        r = 2;
        for (x = -r; x <= r; ++x) {
            for (z = -r; z <= r; ++z) {
                if (Math.abs(x) + Math.abs(z) >= 2 && !(rand.m_188501_() < 0.3f)) continue;
                this.setBlockIfOk(changedLeaves, level, pos.m_7918_(x, 3, z), leaves);
            }
        }
    }

    private void placeBranch(WorldGenLevel level, RandomSource rand, BlockPos pos, int terminationHeight, Direction direction, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        BlockState log = Blocks.f_271170_.m_49966_();
        BlockState sideLog = (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
        int dist = rand.m_188503_(4) + 5;
        for (int i = 0; i < dist && pos.m_123342_() < terminationHeight; ++i) {
            boolean up = rand.m_188499_() && i > 1;
            pos = pos.m_121945_(up ? Direction.UP : direction);
            if (i > 0) {
                pos = pos.m_5484_(direction.m_122427_(), rand.m_188503_(2) - 1);
            }
            this.setBlockIfOk(changedLogs, level, pos, up ? log : sideLog);
        }
        pos = pos.m_7494_();
        this.setBlockIfOk(changedLogs, level, pos, log);
        this.placeTopLeaves(level, rand, pos, changedLogs, changedLeaves);
    }
}

