/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.feature;

import com.legacy.structure_gel.core.util.Internal;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;

public abstract class AbstractSkyTreeFeature
extends TreeFeature {
    public static final TreeConfiguration DUMMY_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_();
    private static final Map<Direction, BooleanProperty> VINE_PROPERTIES = (Map)VineBlock.f_57838_.entrySet().stream().filter(e -> e.getKey() != Direction.UP).collect(Util.m_137448_());
    protected final TreeProperties.Baked properties;

    public AbstractSkyTreeFeature(TreeProperties properties) {
        super(TreeConfiguration.f_68184_);
        this.properties = properties.bake();
    }

    public boolean natural() {
        return this.properties.isNatural;
    }

    @Internal
    public final boolean m_225257_(WorldGenLevel level, RandomSource rand, BlockPos pos, @Deprecated BiConsumer<BlockPos, BlockState> changedRoots, BiConsumer<BlockPos, BlockState> changedLogs, FoliagePlacer.FoliageSetter changedLeaves, TreeConfiguration config) {
        BlockPos groundPos = pos.m_7495_();
        if (this.isValidGround(level, level.m_8055_(groundPos), groundPos)) {
            int height = this.properties.heightFunc.apply(rand);
            boolean placed = this.place(level, rand, pos, height, changedLogs, (arg_0, arg_1) -> ((FoliagePlacer.FoliageSetter)changedLeaves).m_271838_(arg_0, arg_1));
            if (placed && this.natural()) {
                this.placeFallenLeaves(level, rand, pos);
            }
            return placed;
        }
        return false;
    }

    public abstract boolean place(WorldGenLevel var1, RandomSource var2, BlockPos var3, int var4, BiConsumer<BlockPos, BlockState> var5, BiConsumer<BlockPos, BlockState> var6);

    public boolean isValidGround(WorldGenLevel level, BlockState state, BlockPos pos) {
        Block block = this.properties.sapling().get().m_60734_();
        if (block instanceof IPlantable) {
            IPlantable plantable = (IPlantable)block;
            return state.canSustainPlant((BlockGetter)level, pos, Direction.UP, plantable);
        }
        return AbstractSkyTreeFeature.m_159759_((BlockState)state) || state.m_60713_(Blocks.f_50093_);
    }

    protected boolean setBlockIfOk(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel level, BlockPos pos, BlockState state) {
        pos = pos.m_7949_();
        Block block = state.m_60734_();
        if (block instanceof RotatedPillarBlock) {
            if (this.isReplaceableByLogs(level, pos)) {
                this.setBlock(changedBlocks, level, pos, state);
                return true;
            }
            return false;
        }
        if (block instanceof LeavesBlock) {
            if (this.isReplaceableByLeaves(level, pos)) {
                this.setBlock(changedBlocks, level, pos, state);
                return true;
            }
            return false;
        }
        if (level.m_46859_(pos) && state.m_60710_((LevelReader)level, pos)) {
            BlockState lower;
            this.setBlock(changedBlocks, level, pos, state);
            if (block instanceof SnowLayerBlock && (lower = level.m_8055_(pos.m_7495_())).m_61138_((Property)BlockStateProperties.f_61451_)) {
                level.m_7731_(pos.m_7495_(), (BlockState)lower.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)), 2);
            }
            return true;
        }
        return false;
    }

    protected void setBlock(@Nullable BiConsumer<BlockPos, BlockState> changedBlocks, WorldGenLevel level, BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        TreeFeature.m_67256_((LevelWriter)level, (BlockPos)pos, (BlockState)state);
        if (changedBlocks != null) {
            changedBlocks.accept(pos, state);
        }
    }

    public boolean isReplaceableByLeaves(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_247087_() || state.m_204336_(BlockTags.f_278411_);
    }

    public boolean isReplaceableByLogs(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_247087_() || state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13106_);
    }

    public static void placeVines(WorldGenLevel level, BlockPos trunkStart, RandomSource rand, int areaWidth, int areaHeight, int minVineLength, int maxVineLength, float placementChance, VineBlock vine, Set<Block> allowedAttachmentBlocks) {
        int halfWidth = Math.max((areaWidth - 1) / 2, 1);
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            for (int z = -halfWidth; z <= halfWidth; ++z) {
                for (int y = 2; y <= areaHeight; ++y) {
                    BlockPos offsetPos = trunkStart.m_7918_(x, y, z);
                    if (!level.m_46859_(offsetPos) || !(rand.m_188501_() < placementChance)) continue;
                    for (Map.Entry<Direction, BooleanProperty> prop : VINE_PROPERTIES.entrySet()) {
                        BlockState vineBlock = (BlockState)vine.m_49966_().m_61124_((Property)prop.getValue(), (Comparable)Boolean.valueOf(true));
                        if (!vineBlock.m_60710_((LevelReader)level, offsetPos) || !allowedAttachmentBlocks.isEmpty() && !allowedAttachmentBlocks.contains(level.m_8055_(offsetPos.m_121945_(prop.getKey())).m_60734_())) continue;
                        int maxLength = rand.m_188503_(maxVineLength - minVineLength) + minVineLength;
                        for (int vineLength = 0; vineLength <= maxLength && level.m_46859_(offsetPos.m_6625_(vineLength)) && vineBlock.m_60710_((LevelReader)level, offsetPos); ++vineLength) {
                            level.m_7731_(offsetPos.m_6625_(vineLength), vineBlock, 6);
                        }
                    }
                }
            }
        }
    }

    protected void placeFallenLeaves(WorldGenLevel level, RandomSource rand, BlockPos centerPos) {
        BlockState leafCarpet = this.properties.leafCarpet;
        if (leafCarpet == null) {
            return;
        }
        float chance = this.properties.leafCarpetChance;
        int range = 4;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                BlockPos offsetPos;
                if (!(rand.m_188501_() < chance)) continue;
                for (int y = 2; !(y < -3 || level.m_8055_((offsetPos = centerPos.m_7918_(x, y, z)).m_7495_()).m_204336_(BlockTags.f_144274_) && (this.setBlockIfOk(null, level, offsetPos, leafCarpet) || !level.m_46859_(offsetPos) && y < 0)); --y) {
                }
            }
        }
    }

    public boolean isAreaOk(WorldGenLevel level, BlockPos pos, int trunkHeight, int trunkWidth, int leafStartHeight, int leafWidth) {
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        if (pos.m_123342_() > minY && pos.m_123342_() + trunkHeight + 1 < maxY) {
            if (trunkWidth == 1) {
                for (y = 0; y <= 1 + trunkHeight && pos.m_123342_() + y >= 1 && pos.m_123342_() + y < maxY; ++y) {
                    if (this.isReplaceableByLogs(level, pos.m_6630_(y))) continue;
                    return false;
                }
            } else {
                for (y = 0; y <= 1 + trunkHeight && pos.m_123342_() + y >= 1 && pos.m_123342_() + y < maxY; ++y) {
                    for (int x = 0; x < trunkWidth; ++x) {
                        for (int z = 0; z < trunkWidth; ++z) {
                            if (this.isReplaceableByLogs(level, pos.m_7918_(x, y, z))) continue;
                            return false;
                        }
                    }
                }
            }
            int width = Math.max((leafWidth - 1) / 2, 1);
            for (int y = leafStartHeight; y <= trunkHeight + 2 && pos.m_123342_() + y >= 0 && pos.m_123342_() + y < maxY; ++y) {
                for (int x = -width; x <= width; ++x) {
                    for (int z = -width; z <= width; ++z) {
                        if (this.isReplaceableByLogs(level, pos.m_7918_(x, y, z))) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static class TreeProperties {
        final Supplier<BlockState> sapling;
        boolean isNatural = true;
        @Nullable
        BlockState leafCarpet = null;
        float leafCarpetChance = 0.0f;
        boolean fromDungeon = false;
        Function<RandomSource, Integer> heightFunc = r -> r.m_188503_(3) + 5;

        private TreeProperties(Supplier<BlockState> sapling) {
            this.sapling = sapling;
        }

        public static TreeProperties of(Supplier<BlockState> sapling) {
            return new TreeProperties(sapling);
        }

        public static TreeProperties natural(Supplier<BlockState> sapling) {
            return TreeProperties.of(sapling).setNatural(true);
        }

        public static TreeProperties artificial(Supplier<BlockState> sapling) {
            return TreeProperties.of(sapling).setNatural(false);
        }

        public TreeProperties setNatural(boolean isNatural) {
            this.isNatural = isNatural;
            return this;
        }

        public TreeProperties leafCarpet(@Nullable BlockState block, float chance) {
            this.leafCarpet = block;
            this.leafCarpetChance = chance;
            return this;
        }

        public TreeProperties leafCarpet(@Nullable BlockState block) {
            return this.leafCarpet(block, 0.2f);
        }

        public TreeProperties fromDungeon() {
            this.fromDungeon = true;
            return this;
        }

        public TreeProperties height(int min, int max) {
            if (min > max || max < 0) {
                throw new IllegalArgumentException("Tried to set a tree's min height bigger than the max, or used negative values");
            }
            return this.height(rand -> min == max ? min : min + rand.m_188503_(max - min + 1));
        }

        public TreeProperties height(Function<RandomSource, Integer> heightFunc) {
            this.heightFunc = heightFunc;
            return this;
        }

        public Baked bake() {
            return new Baked(this.sapling, this.isNatural, this.leafCarpet, this.leafCarpetChance, this.fromDungeon, this.heightFunc);
        }

        public record Baked(Supplier<BlockState> sapling, boolean isNatural, BlockState leafCarpet, float leafCarpetChance, boolean fromDungeon, Function<RandomSource, Integer> heightFunc) {
        }
    }
}

