/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.world.dimension;

import com.legacy.rediscovered.world.dimension.noise.BetaOctavesNoiseGenerator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class BetaSkyChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<BetaSkyChunkGenerator> SKYLANDS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(chunkGen -> chunkGen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(chunkGen -> chunkGen.m_224341_())).apply((Applicative)instance, instance.stable(BetaSkyChunkGenerator::new)));
    private Random genRandom;
    private BetaOctavesNoiseGenerator octaves1;
    private BetaOctavesNoiseGenerator octaves2;
    private BetaOctavesNoiseGenerator octaves3;
    private BetaOctavesNoiseGenerator scaleNoise;
    private BetaOctavesNoiseGenerator octaves7;
    private double[] octaveArr1;
    private double[] octaveArr2;
    private double[] octaveArr3;
    private double[] octaveArr4;
    private double[] octaveArr5;
    private double[] heightNoise;
    public static final int CHUNK_SIZE = 16;

    public BetaSkyChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settingsIn) {
        super(biomeSource, settingsIn);
    }

    public ChunkGeneratorStructureState m_255169_(HolderLookup<StructureSet> structureRegistry, RandomState rand, long serverSeed) {
        this.genRandom = new Random(serverSeed);
        this.octaves1 = new BetaOctavesNoiseGenerator(this.genRandom, 16);
        this.octaves2 = new BetaOctavesNoiseGenerator(this.genRandom, 16);
        this.octaves3 = new BetaOctavesNoiseGenerator(this.genRandom, 8);
        this.scaleNoise = new BetaOctavesNoiseGenerator(this.genRandom, 10);
        this.octaves7 = new BetaOctavesNoiseGenerator(this.genRandom, 16);
        return super.m_255169_(structureRegistry, rand, serverSeed);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return SKYLANDS_CODEC;
    }

    public void m_214194_(WorldGenRegion level, StructureManager structureManager, RandomState randState, ChunkAccess chunkAccess) {
        if (!SharedConstants.m_183707_((ChunkPos)chunkAccess.m_7697_())) {
            this.replaceBlocksForBiome(chunkAccess.m_7697_().f_45578_, chunkAccess.m_7697_().f_45579_, chunkAccess, level.m_213780_());
        }
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        int x = chunk.m_7697_().f_45578_;
        int z = chunk.m_7697_().f_45579_;
        this.genRandom.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.generateTerrain(chunk.m_7697_(), (state, pos) -> {
            if (state != null) {
                chunk.m_6978_(pos, state, false);
            }
        });
        return CompletableFuture.completedFuture(chunk);
    }

    private void generateTerrain(ChunkPos chunkPos, BiConsumer<BlockState, BlockPos> stateConsumer) {
        int horizontalUnit = 2;
        int k = horizontalUnit + 1;
        int byte1 = 33;
        int l = horizontalUnit + 1;
        this.heightNoise = this.octaveGenerator(this.heightNoise, chunkPos.f_45578_ * horizontalUnit, 0, chunkPos.f_45579_ * horizontalUnit, k, byte1, l);
        for (int xFactor = 0; xFactor < horizontalUnit; ++xFactor) {
            for (int zFactor = 0; zFactor < horizontalUnit; ++zFactor) {
                for (int yFactor = 0; yFactor < 32; ++yFactor) {
                    double d = 0.25;
                    double d1 = this.heightNoise[((xFactor + 0) * l + (zFactor + 0)) * byte1 + (yFactor + 0)];
                    double d2 = this.heightNoise[((xFactor + 0) * l + (zFactor + 1)) * byte1 + (yFactor + 0)];
                    double d3 = this.heightNoise[((xFactor + 1) * l + (zFactor + 0)) * byte1 + (yFactor + 0)];
                    double d4 = this.heightNoise[((xFactor + 1) * l + (zFactor + 1)) * byte1 + (yFactor + 0)];
                    double d5 = (this.heightNoise[((xFactor + 0) * l + (zFactor + 0)) * byte1 + (yFactor + 1)] - d1) * d;
                    double d6 = (this.heightNoise[((xFactor + 0) * l + (zFactor + 1)) * byte1 + (yFactor + 1)] - d2) * d;
                    double d7 = (this.heightNoise[((xFactor + 1) * l + (zFactor + 0)) * byte1 + (yFactor + 1)] - d3) * d;
                    double d8 = (this.heightNoise[((xFactor + 1) * l + (zFactor + 1)) * byte1 + (yFactor + 1)] - d4) * d;
                    for (int yn = 0; yn < 4; ++yn) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int xn = 0; xn < 8; ++xn) {
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int zn = 0; zn < 8; ++zn) {
                                BlockState state = null;
                                if (d15 > 0.0) {
                                    state = ((NoiseGeneratorSettings)this.m_224341_().m_203334_()).f_64440_();
                                }
                                int x = xn + xFactor * 8;
                                int y = yn + yFactor * 4;
                                int z = zn + zFactor * 8;
                                stateConsumer.accept(state, new BlockPos(x, y, z));
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] octaveGenerator(double[] values, int xPos, int zPos, int size1, int size2, int size3, int j1) {
        if (values == null) {
            values = new double[size2 * size3 * j1];
        }
        double noiseFactor = 684.412;
        double d1 = 684.412;
        this.octaveArr4 = this.scaleNoise.generateNoiseOctaves(this.octaveArr4, xPos, size1, size2, j1, 1.121, 1.121, 0.5);
        this.octaveArr5 = this.octaves7.generateNoiseOctaves(this.octaveArr5, xPos, size1, size2, j1, 200.0, 200.0, 0.5);
        this.octaveArr1 = this.octaves3.generateNoiseOctaves(this.octaveArr1, xPos, zPos, size1, size2, size3, j1, (noiseFactor *= 2.0) / 80.0, d1 / 160.0, noiseFactor / 80.0);
        this.octaveArr2 = this.octaves1.generateNoiseOctaves(this.octaveArr2, xPos, zPos, size1, size2, size3, j1, noiseFactor, d1, noiseFactor);
        this.octaveArr3 = this.octaves2.generateNoiseOctaves(this.octaveArr3, xPos, zPos, size1, size2, size3, j1, noiseFactor, d1, noiseFactor);
        int k1 = 0;
        int l1 = 0;
        for (int j2 = 0; j2 < size2; ++j2) {
            for (int l2 = 0; l2 < j1; ++l2) {
                double d6;
                double d3 = 0.5;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.octaveArr4[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.octaveArr5[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) > 1.0) {
                    d6 = 1.0;
                }
                d6 /= 8.0;
                d6 = 0.0;
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)size3 / 16.0;
                ++l1;
                double d7 = (double)size3 / 2.0;
                for (int j3 = 0; j3 < size3; ++j3) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 8.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= -1.0;
                    }
                    double d10 = this.octaveArr2[k1] / 512.0;
                    double d11 = this.octaveArr3[k1] / 512.0;
                    double d12 = (this.octaveArr1[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    int k3 = 32;
                    if (j3 > size3 - k3) {
                        double d13 = (float)(j3 - (size3 - k3)) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < (k3 = 8)) {
                        double d14 = (float)(k3 - j3) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    values[k1] = d8;
                    ++k1;
                }
            }
        }
        return values;
    }

    private void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkAccess chunk, RandomSource rand) {
        BlockState grass = Blocks.f_50440_.m_49966_();
        BlockState dirt = Blocks.f_50493_.m_49966_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dirtDepth = -1;
                for (int y = 127; y >= 0; --y) {
                    BlockState state = chunk.m_8055_(new BlockPos(x, y, z));
                    if (state.m_60795_()) {
                        dirtDepth = -1;
                        continue;
                    }
                    if (state.m_60734_() != Blocks.f_50069_) continue;
                    if (dirtDepth == -1) {
                        dirtDepth = 2;
                        chunk.m_6978_(new BlockPos(x, y, z), grass, false);
                        continue;
                    }
                    if (dirtDepth <= 0) continue;
                    if (dirtDepth > 1 || rand.m_188499_()) {
                        chunk.m_6978_(new BlockPos(x, y, z), dirt, false);
                    }
                    --dirtDepth;
                }
            }
        }
    }

    public int m_214096_(int x, int z, Heightmap.Types heightmap, LevelHeightAccessor level, RandomState rand) {
        return this.m_224239_(level, rand, x, z, null, heightmap.m_64299_()).orElse(level.m_141937_());
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState rand) {
        MutableObject column = new MutableObject();
        this.m_224239_(level, rand, x, z, (MutableObject<NoiseColumn>)column, null);
        return (NoiseColumn)column.getValue();
    }

    protected OptionalInt m_224239_(LevelHeightAccessor level, RandomState rand, int x, int z, @Nullable MutableObject<NoiseColumn> column, @Nullable Predicate<BlockState> stoppingState) {
        BlockState[] stateColumn;
        int minHeight = level.m_141937_();
        BlockState[] states = new BlockState[level.m_141928_()];
        MutableInt lastY = new MutableInt(-1);
        this.generateTerrain(new ChunkPos(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z)), (state, pos) -> {
            if (SectionPos.m_123207_((int)x) == pos.m_123341_() && SectionPos.m_123207_((int)z) == pos.m_123343_()) {
                int y = pos.m_123342_() - minHeight;
                states[y] = state == null ? Blocks.f_50016_.m_49966_() : state;
                lastY.increment();
            }
        });
        int j = lastY.intValue();
        if (j > -1) {
            stateColumn = new BlockState[j];
            System.arraycopy(states, 0, stateColumn, 0, j);
        } else {
            stateColumn = states;
        }
        if (column != null) {
            column.setValue((Object)new NoiseColumn(minHeight, stateColumn));
        }
        if (stoppingState != null) {
            for (int i = stateColumn.length - 1; i > -1; --i) {
                BlockState state2 = stateColumn[i];
                if (!stoppingState.test(state2)) continue;
                return OptionalInt.of(i + 1 + minHeight);
            }
            return OptionalInt.of(minHeight);
        }
        return OptionalInt.empty();
    }

    public void m_213600_(List<String> pInfo, RandomState randomState, BlockPos pos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = randomState.m_224578_();
        DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        double d0 = noiserouter.f_209389_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext);
        pInfo.add("NoiseRouter T: " + decimalformat.format(noiserouter.f_209384_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " V: " + decimalformat.format(noiserouter.f_224392_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(noiserouter.f_209386_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(noiserouter.f_209387_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(noiserouter.f_209388_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.m_224435_((float)((float)d0))) + " AS: " + decimalformat.format(noiserouter.f_209390_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(noiserouter.f_209391_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)));
    }

    public void m_213679_(WorldGenRegion pLevel, long pSeed, RandomState pRandom, BiomeManager pBiomeManager, StructureManager pStructureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
    }
}

