/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.block.BasicPoiBlock;
import com.legacy.rediscovered.compat.everycompat.EveryCompatModule;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegisterEvent;

public class RediscoveredPoiTypes {
    public static final RegistrarHandler<PoiType> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_256805_, (String)"rediscovered");
    public static final Registrar.Static<PoiType> CHAIR = RediscoveredPoiTypes.create("chair", () -> RediscoveredPoiTypes.builder().states(RediscoveredBlocks.oak_chair, RediscoveredBlocks.oak_chair, RediscoveredBlocks.birch_chair, RediscoveredBlocks.spruce_chair, RediscoveredBlocks.jungle_chair, RediscoveredBlocks.acacia_chair, RediscoveredBlocks.dark_oak_chair, RediscoveredBlocks.mangrove_chair, RediscoveredBlocks.bamboo_chair, RediscoveredBlocks.cherry_chair, RediscoveredBlocks.warped_chair, RediscoveredBlocks.crimson_chair).states("everycomp", () -> EveryCompatModule.getChairs()).build());
    public static final Registrar.Static<PoiType> NETHER_REACTOR_CORE = RediscoveredPoiTypes.create("nether_reactor_core", () -> RediscoveredPoiTypes.builder().states(RediscoveredBlocks.nether_reactor_core).build());
    public static final Registrar.Static<PoiType> SKYLANDS_PORTAL = RediscoveredPoiTypes.create("skylands_portal", () -> RediscoveredPoiTypes.builder().states(RediscoveredBlocks.skylands_portal).build());
    public static final Registrar.Static<PoiType> GLOWING_OBSIDIAN = RediscoveredPoiTypes.create("glowing_obsidian", () -> RediscoveredPoiTypes.builder().states((BlockState)RediscoveredBlocks.glowing_obsidian.m_49966_().m_61124_((Property)BasicPoiBlock.IS_POI, (Comparable)Boolean.valueOf(true))).build());
    public static final Registrar.Static<PoiType> MINI_DRAGON_PYLON = RediscoveredPoiTypes.create("mini_dragon_pylon", () -> RediscoveredPoiTypes.builder().states(RediscoveredBlocks.mini_dragon_pylon).build());

    public static void init(RegisterEvent event) {
        HANDLER.registerValues(event);
    }

    private static Builder builder() {
        return new Builder();
    }

    private static Builder village() {
        return RediscoveredPoiTypes.builder().maxTickets(1).validDistance(1);
    }

    private static Registrar.Static<PoiType> create(String name, Supplier<PoiType> builder) {
        return HANDLER.createStatic(name, builder);
    }

    private static class Builder {
        Set<BlockState> states = new HashSet<BlockState>();
        int maxTickets = 0;
        int validDistance = 1;

        private Builder() {
        }

        Builder maxTickets(int maxTickets) {
            this.maxTickets = maxTickets;
            return this;
        }

        Builder validDistance(int validDistance) {
            this.validDistance = validDistance;
            return this;
        }

        Builder states(BlockState ... states) {
            for (BlockState state : states) {
                this.states.add(state);
            }
            return this;
        }

        Builder states(Block ... blocks) {
            for (Block block : blocks) {
                for (BlockState state : block.m_49965_().m_61056_()) {
                    this.states.add(state);
                }
            }
            return this;
        }

        Builder states(String modCondition, Supplier<Collection<Block>> blockSupplier) {
            if (ModList.get().isLoaded(modCondition)) {
                this.states((Block[])blockSupplier.get().toArray(Block[]::new));
            }
            return this;
        }

        Builder states(Collection<Block> blocks, Predicate<BlockState> condition) {
            for (Block block : blocks) {
                block.m_49965_().m_61056_().stream().filter(condition::test).forEach(this.states::add);
            }
            return this;
        }

        Builder states(Block block, Predicate<BlockState> condition) {
            return this.states(List.of(block), condition);
        }

        PoiType build() {
            PoiType ret = new PoiType(this.states, this.maxTickets, this.validDistance);
            return ret;
        }
    }
}

