/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.particles.DragonBreathPourParticle;
import com.legacy.rediscovered.client.particles.LightningBoltData;
import com.legacy.rediscovered.client.particles.LightningBoltParticle;
import com.legacy.rediscovered.client.particles.NetherReactorGrowthParticle;
import com.legacy.rediscovered.client.particles.NetherReactorPulseData;
import com.legacy.rediscovered.client.particles.NetherReactorPulseParticle;
import com.legacy.rediscovered.client.particles.PylonShieldBlastData;
import com.legacy.rediscovered.client.particles.PylonShieldBlastParticle;
import com.legacy.rediscovered.client.particles.ShockwaveData;
import com.legacy.rediscovered.client.particles.ShockwaveParticle;
import com.legacy.rediscovered.client.particles.SkylandsPortalParticle;
import com.legacy.rediscovered.client.particles.WindData;
import com.legacy.rediscovered.client.particles.WindParticle;
import com.mojang.serialization.Codec;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.registries.RegisterEvent;

public class RediscoveredParticles {
    public static final ParticleType<NetherReactorPulseData> NETHER_REACTOR_PULSE = RediscoveredParticles.customParticleType(true, NetherReactorPulseData.DESERIALIZER, NetherReactorPulseData.CODEC);
    public static final SimpleParticleType NETHER_REACTOR_GROWTH = new SimpleParticleType(false);
    public static final SimpleParticleType SKYLANDS_PORTAL = new SimpleParticleType(false);
    public static final ParticleType<PylonShieldBlastData> PYLON_SHIELD_BLAST = RediscoveredParticles.customParticleType(true, PylonShieldBlastData.DESERIALIZER, PylonShieldBlastData.CODEC);
    public static final ParticleType<ShockwaveData> SHOCKWAVE = RediscoveredParticles.customParticleType(true, ShockwaveData.DESERIALIZER, ShockwaveData.CODEC);
    public static final ParticleType<LightningBoltData> LIGHTNINGBOLT = RediscoveredParticles.customParticleType(false, LightningBoltData.DESERIALIZER, LightningBoltData.CODEC);
    public static final ParticleType<WindData> WIND = RediscoveredParticles.customParticleType(false, WindData.DESERIALIZER, WindData.CODEC);
    public static final SimpleParticleType DRAGON_BREATH_POUR = new SimpleParticleType(false);

    public static void init(RegisterEvent event) {
        RediscoveredParticles.register(event, "nether_reactor_pulse", NETHER_REACTOR_PULSE);
        RediscoveredParticles.register(event, "nether_reactor_growth", NETHER_REACTOR_GROWTH);
        RediscoveredParticles.register(event, "skylands_portal", SKYLANDS_PORTAL);
        RediscoveredParticles.register(event, "pylon_shield_blast", PYLON_SHIELD_BLAST);
        RediscoveredParticles.register(event, "shockwave", SHOCKWAVE);
        RediscoveredParticles.register(event, "lightningbolt", LIGHTNINGBOLT);
        RediscoveredParticles.register(event, "wind", WIND);
        RediscoveredParticles.register(event, "dragon_breath_pour", DRAGON_BREATH_POUR);
    }

    private static void register(RegisterEvent event, String key, ParticleType<?> particle) {
        event.register(Registries.f_256890_, RediscoveredMod.locate(key), () -> particle);
    }

    private static <T extends ParticleOptions> ParticleType<T> customParticleType(boolean overrideLimiter, ParticleOptions.Deserializer<T> deserializer, final Codec<T> codec) {
        return new ParticleType<T>(overrideLimiter, deserializer){

            public Codec<T> m_7652_() {
                return codec;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factories {
        public static void init(RegisterParticleProvidersEvent event) {
            event.registerSpecial(NETHER_REACTOR_PULSE, (ParticleProvider)new NetherReactorPulseParticle.Factory());
            event.registerSpriteSet((ParticleType)NETHER_REACTOR_GROWTH, NetherReactorGrowthParticle.Factory::new);
            event.registerSpriteSet((ParticleType)SKYLANDS_PORTAL, SkylandsPortalParticle.Factory::new);
            event.registerSpecial(PYLON_SHIELD_BLAST, (ParticleProvider)new PylonShieldBlastParticle.Factory());
            event.registerSpecial(SHOCKWAVE, (ParticleProvider)new ShockwaveParticle.Factory());
            event.registerSpecial(LIGHTNINGBOLT, (ParticleProvider)new LightningBoltParticle.Factory());
            event.registerSpriteSet(WIND, WindParticle.Factory::new);
            event.registerSpriteSet((ParticleType)DRAGON_BREATH_POUR, DragonBreathPourParticle.Factory::new);
        }
    }
}

