/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class RediscoveredLootModifiers {
    public static final RegistrarHandler<Codec<? extends IGlobalLootModifier>> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"rediscovered");
    public static final Registrar.Static<Codec<AddItemLootModifier>> ADD_SINGLE_ITEM = HANDLER.createStatic("add_single_item", () -> AddItemLootModifier.CODEC);

    public static class AddItemLootModifier
    extends LootModifier {
        private static final Codec<AddItemLootModifier> CODEC = RecordCodecBuilder.create(instance -> AddItemLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)Codec.FLOAT.fieldOf("chance").forGetter(g -> Float.valueOf(g.chance))).and((App)ItemStack.f_41582_.fieldOf("item").forGetter(g -> g.item)).apply((Applicative)instance, AddItemLootModifier::new));
        private final float chance;
        private final ItemStack item;

        public AddItemLootModifier(LootItemCondition[] conditions, float chance, ItemStack item) {
            super(conditions);
            this.chance = chance;
            this.item = item;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC;
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (context.m_230907_().m_188501_() < this.chance) {
                generatedLoot.add((Object)this.item.m_41777_());
            }
            return generatedLoot;
        }
    }
}

