/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.google.common.collect.ImmutableList;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.world.feature.AbstractSkyTreeFeature;
import com.legacy.rediscovered.world.feature.AncientCherryTreeFeature;
import com.legacy.rediscovered.world.feature.IceAndSnowSkyFeature;
import com.legacy.rediscovered.world.feature.SkylandsPoolFeature;
import com.legacy.rediscovered.world.filter.NoVillageFilter;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.registries.RegisterEvent;

public class RediscoveredFeatures {
    public static final Feature<NoneFeatureConfiguration> SKY_SNOW = new IceAndSnowSkyFeature<NoneFeatureConfiguration>(NoneFeatureConfiguration.f_67815_);
    public static final AncientCherryTreeFeature ANCIENT_CHERRY_TREE = new AncientCherryTreeFeature(AbstractSkyTreeFeature.TreeProperties.natural(() -> RediscoveredBlocks.ancient_cherry_sapling.m_49966_()).height(5, 8));
    public static final Feature<SkylandsPoolFeature.Config> POOL = new SkylandsPoolFeature(SkylandsPoolFeature.Config.CODEC);
    private static RegisterEvent registerEvent;

    public static void init(RegisterEvent event) {
        registerEvent = event;
        RediscoveredFeatures.register("sky_snow", SKY_SNOW);
        RediscoveredFeatures.register("ancient_cherry_tree", ANCIENT_CHERRY_TREE);
        RediscoveredFeatures.register("pool", POOL);
    }

    private static void register(String key, Feature<?> feature) {
        registerEvent.register(Registries.f_256833_, RediscoveredMod.locate(key), () -> feature);
    }

    public static class Placed {
        public static final RegistrarHandler<PlacedFeature> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_256988_, (String)"rediscovered");
        private static final VerticalAnchor BOTTOM = VerticalAnchor.m_158922_((int)0);
        public static final Registrar.Pointer<PlacedFeature> OVERWORLD_RUBY_ORE = Placed.register("overworld_ruby_ore", Configured.RUBY_ORE, () -> Placed.commonOrePlacement(100, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16), (VerticalAnchor)VerticalAnchor.m_158922_((int)480))));
        public static final Registrar.Pointer<PlacedFeature> COAL_ORE = Placed.register("coal_ore", Configured.COAL_ORE, () -> Placed.commonOrePlacement(22, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)BOTTOM, (VerticalAnchor)VerticalAnchor.m_158922_((int)186))));
        public static final Registrar.Pointer<PlacedFeature> IRON_ORE = Placed.register("iron_ore", Configured.IRON_ORE, () -> Placed.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)11), (VerticalAnchor)VerticalAnchor.m_158922_((int)186))));
        public static final Registrar.Pointer<PlacedFeature> IRON_ORE_BURRIED = Placed.register("iron_ore_burried", Configured.IRON_ORE_BURRIED, () -> Placed.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)11), (VerticalAnchor)VerticalAnchor.m_158922_((int)88))));
        public static final Registrar.Pointer<PlacedFeature> GOLD_ORE = Placed.register("gold_ore", Configured.GOLD_ORE, () -> Placed.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-57), (VerticalAnchor)VerticalAnchor.m_158922_((int)57))));
        public static final Registrar.Pointer<PlacedFeature> LAPIS_ORE = Placed.register("lapis_ore", Configured.LAPIS_ORE, () -> Placed.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)43), (VerticalAnchor)VerticalAnchor.m_158922_((int)144))));
        public static final Registrar.Pointer<PlacedFeature> DIAMOND_ORE_BURRIED = Placed.register("diamond_ore_burried", Configured.DIAMOND_ORE_BURRIED, () -> Placed.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)6), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))));
        public static final Registrar.Pointer<PlacedFeature> REDSTONE_ORE = Placed.register("redstone_ore", Configured.REDSTONE_ORE, () -> Placed.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)25), (VerticalAnchor)VerticalAnchor.m_158922_((int)100))));
        public static final Registrar.Pointer<PlacedFeature> RUBY_ORE_SMALL = Placed.register("ruby_ore_small", Configured.RUBY_ORE_SMALL, () -> Placed.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)BOTTOM, (VerticalAnchor)VerticalAnchor.m_158922_((int)200))));
        public static final Registrar.Pointer<PlacedFeature> RUBY_ORE_BURRIED = Placed.register("ruby_ore_burried", Configured.RUBY_ORE_BURRIED, () -> Placed.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)BOTTOM, (VerticalAnchor)VerticalAnchor.m_158922_((int)400))));
        public static final Registrar.Pointer<PlacedFeature> COPPER_ORE = Placed.register("copper_ore", Configured.COPPER_ORE, () -> Placed.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)46), (VerticalAnchor)VerticalAnchor.m_158922_((int)153))));
        public static final Registrar.Pointer<PlacedFeature> GRANITE_ORE = Placed.register("granite_ore", Configured.GRANITE_ORE, () -> Placed.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)BOTTOM, (VerticalAnchor)VerticalAnchor.m_158922_((int)200))));
        public static final Registrar.Pointer<PlacedFeature> ANDESITE_ORE = Placed.register("andesite_ore", Configured.ANDESITE_ORE, () -> Placed.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)BOTTOM, (VerticalAnchor)VerticalAnchor.m_158922_((int)200))));
        public static final Registrar.Pointer<PlacedFeature> CALCITE_ORE = Placed.register("calcite_ore", Configured.CALCITE_ORE, () -> Placed.rareOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)BOTTOM, (VerticalAnchor)VerticalAnchor.m_158922_((int)40))));
        public static final Registrar.Pointer<PlacedFeature> CLAY_ORE = Placed.register("clay_ore", Configured.CLAY_ORE, () -> Placed.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)55), (VerticalAnchor)VerticalAnchor.m_158922_((int)200))));
        public static final Registrar.Pointer<PlacedFeature> CHERRY_TREE = Placed.register("cherry_tree", Configured.CHERRY_TREE, () -> Placed.treePlacement((PlacementModifier)RarityFilter.m_191900_((int)4), RediscoveredBlocks.ancient_cherry_sapling));
        public static final Registrar.Pointer<PlacedFeature> COMMON_CHERRY_TREE = Placed.register("common_cherry_tree", Configured.CHERRY_TREE, () -> Placed.treePlacement((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)1, (int)3)), RediscoveredBlocks.ancient_cherry_sapling));
        public static final Registrar.Pointer<PlacedFeature> WOODED_MIX = Placed.register("wooded_mix", Configured.WOODED_MIX, () -> Placed.treePlacement((PlacementModifier)CountPlacement.m_191628_((int)3), RediscoveredBlocks.ancient_cherry_sapling));
        public static final Registrar.Pointer<PlacedFeature> RAINFOREST_MIX = Placed.register("rainforest_mix", Configured.RAINFOREST_MIX, () -> Placed.treePlacement((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)3, (int)4)), Blocks.f_50746_));
        public static final Registrar.Pointer<PlacedFeature> CLASSIC_FLOWERS = Placed.register("classic_flowers", Configured.CLASSIC_FLOWERS, () -> List.of(RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final Registrar.Pointer<PlacedFeature> WOODED_PLANT_MIX = Placed.register("wooded_plant_mix", Configured.WOODED_PLANT_MIX, () -> List.of(CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)2)), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final Registrar.Pointer<PlacedFeature> FLOWER_CHERRY_SPARSE = Placed.register("flower_cherry_sparse", VegetationFeatures.f_271409_, () -> List.of(NoiseThresholdCountPlacement.m_191756_((double)-0.4, (int)1, (int)0), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final Registrar.Pointer<PlacedFeature> FLOWER_CHERRY_COMMON = Placed.register("flower_cherry_common", VegetationFeatures.f_271409_, () -> List.of(NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)4, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final Registrar.Pointer<PlacedFeature> POOL = Placed.register("pool", Configured.POOL, () -> List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        public static final Registrar.Pointer<PlacedFeature> ICE_AND_SNOW_SKYLANDS = Placed.register("ice_and_snow_skylands", Configured.ICE_AND_SNOW_SKYLANDS, () -> List.of(BiomeFilter.m_191561_()));

        private static Registrar.Pointer<PlacedFeature> register(String key, Registrar.Pointer<ConfiguredFeature<?, ?>> feature, Supplier<List<PlacementModifier>> mods) {
            return HANDLER.createPointer(key, b -> new PlacedFeature((Holder)feature.getHolder(b).get(), List.copyOf((Collection)mods.get())));
        }

        private static Registrar.Pointer<PlacedFeature> register(String key, ResourceKey<ConfiguredFeature<?, ?>> feature, Supplier<List<PlacementModifier>> mods) {
            return HANDLER.createPointer(key, b -> new PlacedFeature((Holder)b.m_255420_(Registries.f_256911_).m_255043_(feature), List.copyOf((Collection)mods.get())));
        }

        private static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier pPlacement) {
            return ImmutableList.builder().add((Object)pPlacement).add((Object)InSquarePlacement.m_191715_()).add((Object)SurfaceWaterDepthFilter.m_191950_((int)0)).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).add((Object)NoVillageFilter.instance());
        }

        public static List<PlacementModifier> treePlacement(PlacementModifier pPlacement, Block pSaplingBlock) {
            return Placed.treePlacementBase(pPlacement).add((Object)BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)pSaplingBlock.m_49966_(), (Vec3i)BlockPos.f_121853_))).build();
        }

        private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier heightRange) {
            return Placed.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), heightRange);
        }

        private static List<PlacementModifier> rareOrePlacement(int onceEvery, PlacementModifier heightRange) {
            return Placed.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)onceEvery), heightRange);
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier count, PlacementModifier heightRange) {
            return List.of(count, InSquarePlacement.m_191715_(), heightRange, BiomeFilter.m_191561_());
        }
    }

    public static class Configured {
        public static final RegistrarHandler<ConfiguredFeature<?, ?>> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_256911_, (String)"rediscovered");
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> CHERRY_TREE = Configured.register("cherry_tree", ANCIENT_CHERRY_TREE, () -> AbstractSkyTreeFeature.DUMMY_CONFIG);
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> WOODED_MIX = Configured.register("wooded_mix", c -> {
            HolderGetter featureGetter = c.m_255420_(Registries.f_256911_);
            return new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)featureGetter.m_255043_(TreeFeatures.f_195123_), (PlacementModifier[])new PlacementModifier[0]), 0.1f), new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)featureGetter.m_255043_(TreeFeatures.f_195130_), (PlacementModifier[])new PlacementModifier[0]), 0.3f)), PlacementUtils.m_206506_((Holder)featureGetter.m_255043_(CHERRY_TREE.getKey()), (PlacementModifier[])new PlacementModifier[0])));
        });
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> RAINFOREST_MIX = Configured.register("rainforest_mix", c -> {
            HolderGetter featureGetter = c.m_255420_(Registries.f_256911_);
            return new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)featureGetter.m_255043_(TreeFeatures.f_195123_), (PlacementModifier[])new PlacementModifier[0]), 0.3f)), PlacementUtils.m_206506_((Holder)featureGetter.m_255043_(TreeFeatures.f_195130_), (PlacementModifier[])new PlacementModifier[0])));
        });
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> ICE_AND_SNOW_SKYLANDS = Configured.register("ice_and_snow_skylands", SKY_SNOW, () -> FeatureConfiguration.f_67737_);
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> CLASSIC_FLOWERS = Configured.register("classic_flowers", Feature.f_65761_, () -> Configured.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)RediscoveredBlocks.rose.m_49966_(), 40).m_146271_((Object)Blocks.f_50111_.m_49966_(), 20).m_146271_((Object)RediscoveredBlocks.paeonia.m_49966_(), 10).m_146271_((Object)RediscoveredBlocks.cyan_rose.m_49966_(), 1)), 64));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> WOODED_PLANT_MIX = Configured.register("wooded_plant_mix", Feature.f_65761_, () -> Configured.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50359_.m_49966_(), 2).m_146271_((Object)Blocks.f_50358_.m_49966_(), 1)), 48));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> POOL = Configured.register("pool", POOL, () -> new SkylandsPoolFeature.Config(Blocks.f_49990_.m_49966_(), (IntProvider)UniformInt.m_146622_((int)4, (int)8), Optional.of(Blocks.f_50440_.m_49966_()), 0.2f, Optional.of(Blocks.f_50129_.m_49966_()), Optional.of(Blocks.f_50129_.m_49966_()), 0.3f, RediscoveredTags.Blocks.SKYLANDS_POOL_REPLACEABLE));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> COAL_ORE = Configured.register("coal_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_49997_.m_49966_(), Blocks.f_152469_.m_49966_()), 20));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> IRON_ORE = Configured.register("iron_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_49996_.m_49966_(), Blocks.f_152468_.m_49966_()), 8));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> IRON_ORE_BURRIED = Configured.register("iron_ore_burried", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_49996_.m_49966_(), Blocks.f_152468_.m_49966_()), 10, 0.75f));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> GOLD_ORE = Configured.register("gold_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_49995_.m_49966_(), Blocks.f_152467_.m_49966_()), 5));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> LAPIS_ORE = Configured.register("lapis_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_50059_.m_49966_(), Blocks.f_152472_.m_49966_()), 7));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> DIAMOND_ORE_BURRIED = Configured.register("diamond_ore_burried", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_50089_.m_49966_(), Blocks.f_152474_.m_49966_()), 3, 0.75f));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> REDSTONE_ORE = Configured.register("redstone_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_50173_.m_49966_(), Blocks.f_152473_.m_49966_()), 6));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> RUBY_ORE = Configured.register("ruby_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(RediscoveredBlocks.ruby_ore.m_49966_(), RediscoveredBlocks.deepslate_ruby_ore.m_49966_()), 4));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> RUBY_ORE_SMALL = Configured.register("ruby_ore_small", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(RediscoveredBlocks.ruby_ore.m_49966_(), RediscoveredBlocks.deepslate_ruby_ore.m_49966_()), 1));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> RUBY_ORE_BURRIED = Configured.register("ruby_ore_burried", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(RediscoveredBlocks.ruby_ore.m_49966_(), RediscoveredBlocks.deepslate_ruby_ore.m_49966_()), 5, 0.7f));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> COPPER_ORE = Configured.register("copper_ore", Feature.f_65731_, () -> new OreConfiguration(Configured.ores(Blocks.f_152505_.m_49966_(), Blocks.f_152506_.m_49966_()), 6));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> GRANITE_ORE = Configured.register("granite_ore", Feature.f_65731_, () -> new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13061_), Blocks.f_50122_.m_49966_(), 48));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> ANDESITE_ORE = Configured.register("andesite_ore", Feature.f_65731_, () -> new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13061_), Blocks.f_50334_.m_49966_(), 64));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> CALCITE_ORE = Configured.register("calcite_ore", Feature.f_65731_, () -> new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13061_), Blocks.f_152497_.m_49966_(), 64));
        public static final Registrar.Pointer<ConfiguredFeature<?, ?>> CLAY_ORE = Configured.register("clay_ore", Feature.f_65731_, () -> new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13061_), Blocks.f_50129_.m_49966_(), 32));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> Registrar.Pointer<ConfiguredFeature<?, ?>> register(String key, F feature, Supplier<FC> config) {
            return HANDLER.createPointer(key, () -> new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
        }

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> Registrar.Pointer<ConfiguredFeature<?, ?>> register(String key, Function<BootstapContext<?>, ConfiguredFeature<?, ?>> fu) {
            return HANDLER.createPointer(key, fu);
        }

        private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int pTries) {
            return FeatureUtils.m_206470_((int)pTries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
        }

        private static List<OreConfiguration.TargetBlockState> ores(BlockState stoneOre, BlockState deepslateOre) {
            return List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144266_), (BlockState)stoneOre), OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144267_), (BlockState)deepslateOre));
        }
    }
}

