/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.entity.AbstractSteveEntity;
import com.legacy.rediscovered.entity.BeastBoyEntity;
import com.legacy.rediscovered.entity.BlackSteveEntity;
import com.legacy.rediscovered.entity.FishEntity;
import com.legacy.rediscovered.entity.PurpleArrowEntity;
import com.legacy.rediscovered.entity.RanaEntity;
import com.legacy.rediscovered.entity.ScarecrowEntity;
import com.legacy.rediscovered.entity.SteveEntity;
import com.legacy.rediscovered.entity.ZombiePigmanEntity;
import com.legacy.rediscovered.entity.dragon.BoltBallEntity;
import com.legacy.rediscovered.entity.dragon.DragonPylonEntity;
import com.legacy.rediscovered.entity.dragon.PylonBurstEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.entity.dragon.ThunderCloudEntity;
import com.legacy.rediscovered.entity.pigman.MeleePigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.entity.pigman.RangedPigmanEntity;
import com.legacy.rediscovered.entity.util.MountableBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.registries.RegisterEvent;

public class RediscoveredEntityTypes {
    public static final EntityType<FishEntity> FISH = RediscoveredEntityTypes.buildEntity("fish", EntityType.Builder.m_20704_(FishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.5f, 0.3f));
    public static final EntityType<PigmanEntity> PIGMAN = RediscoveredEntityTypes.buildEntity("pigman", EntityType.Builder.m_20704_(PigmanEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.9f));
    public static final EntityType<MeleePigmanEntity> MELEE_PIGMAN = RediscoveredEntityTypes.buildEntity("melee_pigman", EntityType.Builder.m_20704_(MeleePigmanEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.9f));
    public static final EntityType<RangedPigmanEntity> RANGED_PIGMAN = RediscoveredEntityTypes.buildEntity("ranged_pigman", EntityType.Builder.m_20704_(RangedPigmanEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.9f));
    public static final EntityType<ZombiePigmanEntity> ZOMBIE_PIGMAN = RediscoveredEntityTypes.buildEntity("zombie_pigman", EntityType.Builder.m_20704_(ZombiePigmanEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.9f).m_20719_());
    public static final EntityType<SteveEntity> STEVE = RediscoveredEntityTypes.buildEntity("steve", EntityType.Builder.m_20704_(SteveEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f));
    public static final EntityType<RanaEntity> RANA = RediscoveredEntityTypes.buildEntity("rana", EntityType.Builder.m_20704_(RanaEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f));
    public static final EntityType<BlackSteveEntity> BLACK_STEVE = RediscoveredEntityTypes.buildEntity("black_steve", EntityType.Builder.m_20704_(BlackSteveEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f));
    public static final EntityType<BeastBoyEntity> BEAST_BOY = RediscoveredEntityTypes.buildEntity("beast_boy", EntityType.Builder.m_20704_(BeastBoyEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f));
    public static final EntityType<ScarecrowEntity> SCARECROW = RediscoveredEntityTypes.buildEntity("scarecrow", EntityType.Builder.m_20704_(ScarecrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.975f));
    public static final EntityType<PurpleArrowEntity> PURPLE_ARROW = RediscoveredEntityTypes.buildEntity("purple_arrow", EntityType.Builder.m_20704_(PurpleArrowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(PurpleArrowEntity::new).setShouldReceiveVelocityUpdates(true).m_20699_(0.5f, 0.5f));
    public static final EntityType<MountableBlockEntity> MOUNTABLE_BLOCK = RediscoveredEntityTypes.buildEntity("mountable_block", EntityType.Builder.m_20704_(MountableBlockEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(MountableBlockEntity::new).m_20699_(1.0f, 1.0f));
    public static final EntityType<RedDragonBossEntity> RED_DRAGON_BOSS = RediscoveredEntityTypes.buildEntity("red_dragon", EntityType.Builder.m_20704_(RedDragonBossEntity::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(16.0f, 8.0f).m_20702_(16));
    public static final EntityType<RedDragonOffspringEntity> RED_DRAGON_OFFSPRING = RediscoveredEntityTypes.buildEntity("red_dragon_offspring", EntityType.Builder.m_20704_(RedDragonOffspringEntity::new, (MobCategory)MobCategory.CREATURE).m_20719_().m_20699_(4.0f, 3.5f).m_20702_(10));
    public static final EntityType<BoltBallEntity> BOLT_BALL = RediscoveredEntityTypes.buildEntity("bolt_ball", EntityType.Builder.m_20704_(BoltBallEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(BoltBallEntity::new).m_20717_(1).m_20719_().m_20720_().m_20699_(2.0f, 2.0f).m_20702_(10));
    public static final EntityType<ThunderCloudEntity> THUNDER_CLOUD = RediscoveredEntityTypes.buildEntity("thunder_cloud", EntityType.Builder.m_20704_(ThunderCloudEntity::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 1.8f).m_20702_(10).m_20719_().m_20717_(Integer.MAX_VALUE));
    public static final EntityType<DragonPylonEntity> DRAGON_PYLON = RediscoveredEntityTypes.buildEntity("dragon_pylon", EntityType.Builder.m_20704_(DragonPylonEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(DragonPylonEntity::new).m_20702_(16).m_20717_(Integer.MAX_VALUE).m_20699_(2.0f, 2.0f));
    public static final EntityType<PylonBurstEntity> PYLON_BURST = RediscoveredEntityTypes.buildEntity("pylon_burst", EntityType.Builder.m_20704_(PylonBurstEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(PylonBurstEntity::new).m_20717_(3).m_20719_().m_20720_().m_20699_(2.0f, 2.0f).m_20702_(10));
    private static RegisterEvent registerEvent;

    public static void init(RegisterEvent event) {
        registerEvent = event;
        RediscoveredEntityTypes.register("fish", FISH);
        RediscoveredEntityTypes.register("pigman", PIGMAN);
        RediscoveredEntityTypes.register("melee_pigman", MELEE_PIGMAN);
        RediscoveredEntityTypes.register("ranged_pigman", RANGED_PIGMAN);
        RediscoveredEntityTypes.register("zombie_pigman", ZOMBIE_PIGMAN);
        RediscoveredEntityTypes.register("steve", STEVE);
        RediscoveredEntityTypes.register("rana", RANA);
        RediscoveredEntityTypes.register("black_steve", BLACK_STEVE);
        RediscoveredEntityTypes.register("beast_boy", BEAST_BOY);
        RediscoveredEntityTypes.register("red_dragon", RED_DRAGON_BOSS);
        RediscoveredEntityTypes.register("red_dragon_offspring", RED_DRAGON_OFFSPRING);
        RediscoveredEntityTypes.register("bolt_ball", BOLT_BALL);
        RediscoveredEntityTypes.register("thunder_cloud", THUNDER_CLOUD);
        RediscoveredEntityTypes.register("dragon_pylon", DRAGON_PYLON);
        RediscoveredEntityTypes.register("pylon_burst", PYLON_BURST);
        RediscoveredEntityTypes.register("scarecrow", SCARECROW);
        RediscoveredEntityTypes.register("purple_arrow", PURPLE_ARROW);
        RediscoveredEntityTypes.register("mountable_block", MOUNTABLE_BLOCK);
    }

    private static void register(String name, EntityType<?> type) {
        if (registerEvent == null) {
            return;
        }
        registerEvent.register(Registries.f_256939_, RediscoveredMod.locate(name), () -> type);
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.m_20712_(RediscoveredMod.find(key));
    }

    private static void mobPlacement(SpawnPlacementRegisterEvent event, EntityType<? extends Mob> pType) {
        event.register(pType, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void onAttributesRegistered(EntityAttributeCreationEvent event) {
        event.put(FISH, AbstractFish.m_27495_().m_22265_());
        event.put(PIGMAN, PigmanEntity.createAttributes().m_22265_());
        event.put(MELEE_PIGMAN, MeleePigmanEntity.createAttributes().m_22265_());
        event.put(RANGED_PIGMAN, RangedPigmanEntity.createAttributes().m_22265_());
        event.put(ZOMBIE_PIGMAN, ZombiePigmanEntity.m_34470_().m_22265_());
        event.put(STEVE, AbstractSteveEntity.createBaseSteveAttributes().m_22265_());
        event.put(RANA, AbstractSteveEntity.createBaseSteveAttributes().m_22265_());
        event.put(BLACK_STEVE, AbstractSteveEntity.createBaseSteveAttributes().m_22265_());
        event.put(BEAST_BOY, AbstractSteveEntity.createBaseSteveAttributes().m_22265_());
        event.put(RED_DRAGON_BOSS, RedDragonBossEntity.createAttributes().m_22265_());
        event.put(RED_DRAGON_OFFSPRING, RedDragonOffspringEntity.createAttributes().m_22265_());
        event.put(DRAGON_PYLON, DragonPylonEntity.createAttributes().m_22265_());
        event.put(SCARECROW, ScarecrowEntity.createAttributes().m_22265_());
    }

    public static void registerPlacements(SpawnPlacementRegisterEvent event) {
        RediscoveredEntityTypes.mobPlacement(event, PIGMAN);
        RediscoveredEntityTypes.mobPlacement(event, STEVE);
        RediscoveredEntityTypes.mobPlacement(event, RANA);
        RediscoveredEntityTypes.mobPlacement(event, BLACK_STEVE);
        RediscoveredEntityTypes.mobPlacement(event, BEAST_BOY);
        RediscoveredEntityTypes.mobPlacement(event, MELEE_PIGMAN);
        RediscoveredEntityTypes.mobPlacement(event, RANGED_PIGMAN);
        event.register(RED_DRAGON_BOSS, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, level, reason, pos, rand) -> false, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(RED_DRAGON_OFFSPRING, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, level, reason, pos, rand) -> false, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register(FISH, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerPlacementOverrides(SpawnPlacementRegisterEvent event) {
        event.register(EntityType.f_20454_, null, null, (type, level, reason, pos, rand) -> {
            if ((reason == MobSpawnType.NATURAL || reason == MobSpawnType.CHUNK_GENERATION) && level.m_6018_() != null && level.m_6018_().m_46472_().equals(RediscoveredDimensions.skylandsKey())) {
                return Monster.m_219019_((EntityType)type, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand);
            }
            return false;
        }, SpawnPlacementRegisterEvent.Operation.OR);
    }
}

