/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredBiomes;
import com.legacy.rediscovered.world.dimension.BetaSkyChunkGenerator;
import com.legacy.structure_gel.api.dimension.DimensionAccessHelper;
import com.legacy.structure_gel.api.dimension.DimensionTypeBuilder;
import com.legacy.structure_gel.api.registry.registrar.DimensionRegistrar;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class RediscoveredDimensions {
    public static final ResourceLocation SKYLANDS_ID = RediscoveredMod.locate("skylands");
    private static final DimensionRegistrar SKYLANDS = RediscoveredDimensions.create();

    public static void init() {
    }

    private static DimensionRegistrar create() {
        Function<BootstapContext, DimensionType> dimType = bootstrap -> DimensionTypeBuilder.of().minY(0).hasRaids(false).respawnAnchorWorks(true).effects(SKYLANDS_ID).build();
        Function<BootstapContext, NoiseGeneratorSettings> noiseSettings = bootstrap -> {
            HolderGetter densityFunctions = bootstrap.m_255420_(Registries.f_257040_);
            HolderGetter noise = bootstrap.m_255420_(Registries.f_256865_);
            return DimensionAccessHelper.newDimensionSettings((NoiseSettings)NoiseSettings.m_224525_((int)0, (int)384, (int)1, (int)2), (BlockState)Blocks.f_50069_.m_49966_(), (BlockState)Blocks.f_50016_.m_49966_(), (NoiseRouter)DimensionAccessHelper.netherNoiseRouter((HolderGetter)densityFunctions, (HolderGetter)noise), (SurfaceRules.RuleSource)SurfaceRuleData.m_198380_((boolean)false, (boolean)false, (boolean)false), (int)0, (boolean)true);
        };
        Function<BootstapContext, ChunkGenerator> chunkGen = bootstrap -> {
            HolderGetter noiseGenSettings = bootstrap.m_255420_(Registries.f_256932_);
            HolderGetter biomes = bootstrap.m_255420_(Registries.f_256952_);
            return new BetaSkyChunkGenerator(RediscoveredDimensions.buildBiomeSource((HolderGetter<Biome>)biomes), (Holder<NoiseGeneratorSettings>)noiseGenSettings.m_255043_(SKYLANDS.getNoiseSettings().getKey()));
        };
        return new DimensionRegistrar(SKYLANDS_ID, dimType, noiseSettings, chunkGen);
    }

    public static BiomeSource buildBiomeSource(HolderGetter<Biome> biomes) {
        return MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)Climate.m_186788_((float)-0.3f, (float)-0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(RediscoveredBiomes.COLD_SKYLANDS.getKey())), Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(RediscoveredBiomes.SKYLANDS.getKey())), Pair.of((Object)Climate.m_186788_((float)0.3f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(RediscoveredBiomes.WOODED_SKYLANDS.getKey())), Pair.of((Object)Climate.m_186788_((float)0.6f, (float)0.6f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(RediscoveredBiomes.RAINFOREST.getKey())))));
    }

    public static ResourceKey<Level> skylandsKey() {
        return SKYLANDS.getLevelKey();
    }
}

