/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredFeatures;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class RediscoveredBiomes {
    public static final RegistrarHandler<Biome> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_256952_, (String)"rediscovered");
    public static final Registrar.Pointer<Biome> SKYLANDS = RediscoveredBiomes.create("skylands", Builders::createSkylandsBiome);
    public static final Registrar.Pointer<Biome> WOODED_SKYLANDS = RediscoveredBiomes.create("wooded_skylands", Builders::createWoodedSkylandsBiome);
    public static final Registrar.Pointer<Biome> COLD_SKYLANDS = RediscoveredBiomes.create("cold_skylands", Builders::createColdSkylandsBiome);
    public static final Registrar.Pointer<Biome> RAINFOREST = RediscoveredBiomes.create("rainforest", Builders::createRainforestBiome);

    private static Registrar.Pointer<Biome> create(String name, Function<BootstapContext<?>, Biome> biome) {
        return HANDLER.createPointer(name, biome);
    }

    public static class Builders {
        public static Biome createSkylandsBiome(BootstapContext<?> bootstrap) {
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.CHERRY_TREE.getKey());
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.FLOWER_CHERRY_SPARSE.getKey());
            return Builders.createBaseSkylandsBiome(bootstrap, builder, spawns, 0.5f, false);
        }

        public static Biome createWoodedSkylandsBiome(BootstapContext<?> bootstrap) {
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.WOODED_MIX.getKey());
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.WOODED_PLANT_MIX.getKey());
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.FLOWER_CHERRY_COMMON.getKey());
            return Builders.createBaseSkylandsBiome(bootstrap, builder, spawns, 0.5f, false);
        }

        public static Biome createColdSkylandsBiome(BootstapContext<?> bootstrap) {
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 80, 3, 4));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.COMMON_CHERRY_TREE.getKey());
            return Builders.createBaseSkylandsBiome(bootstrap, builder, spawns, 0.0f, false);
        }

        public static Biome createRainforestBiome(BootstapContext<?> bootstrap) {
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.RAINFOREST_MIX.getKey());
            builder.m_255155_(GenerationStep.Decoration.LAKES, RediscoveredFeatures.Placed.POOL.getKey());
            return Builders.createBaseSkylandsBiome(bootstrap, builder, spawns, 0.95f, true);
        }

        public static Biome createBaseSkylandsBiome(BootstapContext<?> bootstrap, BiomeGenerationSettings.Builder builder, MobSpawnSettings.Builder spawns, float temp, boolean humid) {
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 150, 2, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20454_, 1, 1, 1));
            spawns.m_48370_(EntityType.f_20454_, 6.5, 1.0);
            spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(RediscoveredEntityTypes.FISH, 1, 2, 2));
            builder.m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, RediscoveredFeatures.Placed.ICE_AND_SNOW_SKYLANDS.getKey());
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RediscoveredFeatures.Placed.CLASSIC_FLOWERS.getKey());
            if (humid) {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195458_);
            } else {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
            }
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, CavePlacements.f_195235_);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195323_);
            Builders.addOres(bootstrap, builder);
            return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47611_(humid ? 0.9f : 0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(10529263).m_48040_(0xB3BBFF).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        private static void addOres(BootstapContext<?> bootstrap, BiomeGenerationSettings.Builder builder) {
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.COAL_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.IRON_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.IRON_ORE_BURRIED.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.GOLD_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.LAPIS_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.DIAMOND_ORE_BURRIED.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.REDSTONE_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.RUBY_ORE_SMALL.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.RUBY_ORE_BURRIED.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.COPPER_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.GRANITE_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.ANDESITE_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.CALCITE_ORE.getKey());
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredFeatures.Placed.CLAY_ORE.getKey());
        }
    }
}

