/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredFeatures;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class RediscoveredBiomeModifiers {
    public static final RegistrarHandler<BiomeModifier> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (String)"rediscovered");
    public static final Registrar.Pointer<BiomeModifier> ADD_RUBY_ORE = HANDLER.createPointer("add_ruby_ore", c -> RediscoveredBiomeModifiers.addFeature(c, GenerationStep.Decoration.UNDERGROUND_ORES, RediscoveredTags.Biomes.HAS_RUBY_ORE, (ResourceKey<PlacedFeature>)RediscoveredFeatures.Placed.OVERWORLD_RUBY_ORE.getKey()));
    public static final Registrar.Pointer<BiomeModifier> ADD_SPAWNS = HANDLER.createPointer("add_rediscovered_natural_spawns", c -> {
        MobSpawnSettings.SpawnerData fish = new MobSpawnSettings.SpawnerData(RediscoveredEntityTypes.FISH, 7, 3, 4);
        return RediscoveredBiomeModifiers.addSpawn(c, RediscoveredTags.Biomes.HAS_FISH_SPAWNS, fish);
    });

    private static BiomeModifier addFeature(BootstapContext<?> bootstrap, GenerationStep.Decoration step, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> feature) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)bootstrap.m_255420_(Registries.f_256952_).m_254956_(spawnTag), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{bootstrap.m_255420_(Registries.f_256988_).m_255043_(feature)}), step);
    }

    private static BiomeModifier addSpawn(BootstapContext<?> bootstrap, TagKey<Biome> spawnTag, MobSpawnSettings.SpawnerData ... data) {
        return new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)bootstrap.m_255420_(Registries.f_256952_).m_254956_(spawnTag), List.of(data));
    }

    private static BiomeModifier removeSpawns(BootstapContext<?> bootstrap, TagKey<Biome> spawnTag, HolderSet<EntityType<?>> entityTypes) {
        return new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)bootstrap.m_255420_(Registries.f_256952_).m_254956_(spawnTag), entityTypes);
    }

    private static List<Holder<EntityType<?>>> getAllEntities() {
        return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(item -> ForgeRegistries.ENTITY_TYPES.getKey(item).m_135827_().equals("rediscovered")).map(t -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(t).get()).toList();
    }
}

