/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.registry;

import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;

public class RediscoveredArmorTrims {
    public static final RegistrarHandler<TrimPattern> PATTERN_HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_266063_, (String)"rediscovered").bootstrap(Pattterns::trimBootstrap);
    public static final RegistrarHandler<TrimMaterial> MATERIAL_HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_266076_, (String)"rediscovered").bootstrap(Materials::materialBootstrap);

    public static interface Materials {
        public static final ResourceKey<TrimMaterial> RUBY = MATERIAL_HANDLER.key("ruby");

        private static void materialBootstrap(BootstapContext<TrimMaterial> context) {
            Materials.register(context, RUBY, (ItemLike)RediscoveredItems.ruby, "#8A1F2D", 0.400173f);
        }

        public static List<ResourceKey<TrimMaterial>> materials() {
            return List.of(RUBY);
        }

        private static void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> key, ItemLike ingredient, String hexColor, float itemModelIndex) {
            Materials.register(context, key, ingredient, hexColor, itemModelIndex, Map.of());
        }

        private static void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> key, ItemLike ingredient, String hexColor, float itemModelIndex, Map<ArmorMaterials, String> overrideArmorMaterials) {
            TrimMaterial trimmaterial = TrimMaterial.m_267605_((String)Materials.assetID(key), (Item)ingredient.m_5456_(), (float)itemModelIndex, (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_material", (ResourceLocation)key.m_135782_())).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)hexColor))), overrideArmorMaterials);
            context.m_255272_(key, (Object)trimmaterial);
        }

        public static String assetID(ResourceKey<TrimMaterial> key) {
            return key.m_135782_().m_135827_() + "-" + key.m_135782_().m_135815_();
        }

        public static String darkerID(ResourceKey<TrimMaterial> key) {
            return Materials.assetID(key) + "_darker";
        }
    }

    public static interface Pattterns {
        public static final ResourceKey<TrimPattern> DRACONIC = PATTERN_HANDLER.key("draconic");

        private static void trimBootstrap(BootstapContext<TrimPattern> context) {
            Pattterns.register(context, DRACONIC, RediscoveredItems.draconic_trim);
        }

        public static List<ResourceKey<TrimPattern>> patterns() {
            return List.of(DRACONIC);
        }

        private static void register(BootstapContext<TrimPattern> context, ResourceKey<TrimPattern> key, Item templateItem) {
            TrimPattern trimpattern = new TrimPattern(key.m_135782_(), BuiltInRegistries.f_257033_.m_263177_((Object)templateItem), (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_pattern", (ResourceLocation)key.m_135782_())));
            context.m_255272_(key, (Object)trimpattern);
        }
    }
}

