/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.s_to_c;

import com.legacy.rediscovered.entity.util.animation.IAnimated;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateAnimationPacket {
    private int entityId;
    private int animId;
    private boolean shouldPlay;

    public UpdateAnimationPacket(int entityId, int animId, boolean shouldPlay) {
        this.entityId = entityId;
        this.animId = animId;
        this.shouldPlay = shouldPlay;
    }

    public static void encoder(UpdateAnimationPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.entityId);
        buff.writeInt(packet.animId);
        buff.writeBoolean(packet.shouldPlay);
    }

    public static UpdateAnimationPacket decoder(FriendlyByteBuf buff) {
        return new UpdateAnimationPacket(buff.readInt(), buff.readInt(), buff.readBoolean());
    }

    public static void handler(UpdateAnimationPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateAnimationPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateAnimationPacket packet) {
        try {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
            if (entity instanceof IAnimated) {
                IAnimated animated = (IAnimated)entity;
                animated.getAnimations().get(packet.animId).forcePlay(packet.shouldPlay);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

