/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.s_to_c;

import com.legacy.rediscovered.capability.entity.IRainCapability;
import com.legacy.rediscovered.capability.entity.RainCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SetLocalRainPacket {
    private final int entity;

    public SetLocalRainPacket(int id) {
        this.entity = id;
    }

    public static void encoder(SetLocalRainPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.entity);
    }

    public static SetLocalRainPacket decoder(FriendlyByteBuf buff) {
        return new SetLocalRainPacket(buff.readInt());
    }

    public static void handler(SetLocalRainPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SetLocalRainPacket.lambda$handler$1(packet, (Supplier)context)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SetLocalRainPacket packet, NetworkEvent.Context context) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Entity entity = level.m_6815_(packet.entity);
        if (entity != null) {
            RainCapability.ifPresent(entity, arg_0 -> SetLocalRainPacket.lambda$handlePacket$3((Level)level, arg_0));
        }
    }

    private static /* synthetic */ void lambda$handlePacket$3(Level level, IRainCapability rain) {
        rain.setRainTime(level.m_46467_());
    }

    private static /* synthetic */ Runnable lambda$handler$1(SetLocalRainPacket packet, Supplier context) {
        return () -> SetLocalRainPacket.lambda$handler$0(packet, (Supplier)context);
    }

    private static /* synthetic */ void lambda$handler$0(SetLocalRainPacket packet, Supplier context) {
        SetLocalRainPacket.handlePacket(packet, (NetworkEvent.Context)context.get());
    }
}

