/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.s_to_c;

import com.legacy.rediscovered.client.RediscoveredClientEvents;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendScreenShakePacket {
    private final float strength;

    public SendScreenShakePacket(float strength) {
        this.strength = strength;
    }

    public static void encoder(SendScreenShakePacket packet, FriendlyByteBuf buff) {
        buff.writeFloat(packet.strength);
    }

    public static SendScreenShakePacket decoder(FriendlyByteBuf buff) {
        return new SendScreenShakePacket(buff.readFloat());
    }

    public static void handler(SendScreenShakePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SendScreenShakePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SendScreenShakePacket packet) {
        try {
            RediscoveredClientEvents.shakeStrength += packet.strength;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

