/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.s_to_c;

import com.legacy.rediscovered.client.RediscoveredClientEvents;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendBossIdPacket {
    private final UUID bossId;

    public SendBossIdPacket(UUID uuid) {
        this.bossId = uuid;
    }

    public static void encoder(SendBossIdPacket packet, FriendlyByteBuf buff) {
        buff.m_130077_(packet.bossId);
    }

    public static SendBossIdPacket decoder(FriendlyByteBuf buff) {
        return new SendBossIdPacket(buff.m_130259_());
    }

    public static void handler(SendBossIdPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SendBossIdPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SendBossIdPacket packet) {
        try {
            RediscoveredClientEvents.ACTIVE_DRAGON_FIGHTS.add(packet.bossId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

