/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.s_to_c;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class AddClientMotionPacket {
    private double x;
    private double y;
    private double z;

    public AddClientMotionPacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encoder(AddClientMotionPacket packet, FriendlyByteBuf buff) {
        buff.writeDouble(packet.x);
        buff.writeDouble(packet.y);
        buff.writeDouble(packet.z);
    }

    public static AddClientMotionPacket decoder(FriendlyByteBuf buff) {
        return new AddClientMotionPacket(buff.readDouble(), buff.readDouble(), buff.readDouble());
    }

    public static void handler(AddClientMotionPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> AddClientMotionPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(AddClientMotionPacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.m_20256_(player.m_20184_().m_82520_(packet.x, packet.y, packet.z));
    }
}

