/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.c_to_s;

import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record DragonStaminaDecreasePacket(int dragonId, float staminaDecrease) {
    public static void encoder(DragonStaminaDecreasePacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.dragonId);
        buff.writeFloat(packet.staminaDecrease);
    }

    public static DragonStaminaDecreasePacket decoder(FriendlyByteBuf buff) {
        return new DragonStaminaDecreasePacket(buff.readInt(), buff.readFloat());
    }

    public static void handler(DragonStaminaDecreasePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            RedDragonOffspringEntity dragon;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            Entity entity = player.m_9236_().m_6815_(packet.dragonId());
            if (entity instanceof RedDragonOffspringEntity && (dragon = (RedDragonOffspringEntity)entity).m_20160_() && player.m_20202_() == dragon && player == dragon.m_269323_() && dragon.m_6688_() == player) {
                dragon.setStamina(Mth.m_14036_((float)(dragon.getStamina() - packet.staminaDecrease()), (float)0.0f, (float)100.0f));
            }
        });
        context.get().setPacketHandled(true);
    }
}

